/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.ISpecialEnderChest;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class OpenInvPlayerListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerJoinEvent event) {
        ISpecialEnderChest chest;
        ISpecialPlayerInventory inventory = OpenInv.inventories.get(event.getPlayer().getName().toLowerCase());
        if (inventory != null) {
            inventory.PlayerGoOnline(event.getPlayer());
        }
        if ((chest = OpenInv.enderChests.get(event.getPlayer().getName().toLowerCase())) != null) {
            chest.PlayerGoOnline(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        ISpecialEnderChest chest;
        ISpecialPlayerInventory inventory = OpenInv.inventories.get(event.getPlayer().getName().toLowerCase());
        if (inventory != null) {
            inventory.PlayerGoOffline();
        }
        if ((chest = OpenInv.enderChests.get(event.getPlayer().getName().toLowerCase())) != null) {
            chest.PlayerGoOffline();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getType() == Material.ENDER_CHEST && event.getPlayer().hasPermission("OpenInv.silent") && OpenInv.GetPlayerSilentChestStatus(event.getPlayer().getName())) {
            event.setCancelled(true);
            event.getPlayer().openInventory(event.getPlayer().getEnderChest());
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getState() instanceof Chest) {
            boolean silentchest = false;
            boolean anychest = false;
            int x = event.getClickedBlock().getX();
            int y = event.getClickedBlock().getY();
            int z = event.getClickedBlock().getZ();
            if (event.getPlayer().hasPermission("OpenInv.silent") && OpenInv.GetPlayerSilentChestStatus(event.getPlayer().getName())) {
                silentchest = true;
            }
            if (event.getPlayer().hasPermission("OpenInv.anychest") && OpenInv.GetPlayerAnyChestStatus(event.getPlayer().getName())) {
                try {
                    anychest = OpenInv.anySilentChest.IsAnyChestNeeded(event.getPlayer(), x, y, z);
                }
                catch (Exception e) {
                    event.getPlayer().sendMessage(ChatColor.RED + "Error while executing openinv. Unsupported CraftBukkit.");
                    e.printStackTrace();
                }
            }
            if ((anychest || silentchest) && !OpenInv.anySilentChest.ActivateChest(event.getPlayer(), anychest, silentchest, x, y, z)) {
                event.setCancelled(true);
            }
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock().getState() instanceof Sign) {
            Player player = event.getPlayer();
            try {
                Sign sign = (Sign)event.getClickedBlock().getState();
                if (player.hasPermission("OpenInv.openinv") && sign.getLine(0).equalsIgnoreCase("[openinv]")) {
                    String text = String.valueOf(sign.getLine(1).trim()) + sign.getLine(2).trim() + sign.getLine(3).trim();
                    player.performCommand("openinv " + text);
                }
            }
            catch (Exception ex) {
                player.sendMessage("Internal Error.");
                ex.printStackTrace();
            }
        }
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Player player = event.getPlayer();
            if (player.getItemInHand().getType().getId() != OpenInv.GetItemOpenInvItem() || !OpenInv.GetPlayerItemOpenInvStatus(player.getName()) || !player.hasPermission("OpenInv.openinv")) {
                return;
            }
            player.performCommand("openinv");
        }
    }
}

