/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.commands;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import com.lishid.openinv.internal.InternalAccessor;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OpenInvPluginCommand
implements CommandExecutor {
    private final OpenInv plugin;
    public static HashMap<Player, String> openInvHistory = new HashMap();

    public OpenInvPluginCommand(OpenInv plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "You can't use this from the console.");
            return true;
        }
        if (!sender.hasPermission("OpenInv.openinv")) {
            sender.sendMessage(ChatColor.RED + "You do not have permission to access player inventories");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("?")) {
            OpenInv.ShowHelp((Player)sender);
            return true;
        }
        Player player = (Player)sender;
        boolean offline = false;
        String history = openInvHistory.get(player);
        if (history == null || history == "") {
            history = player.getName();
            openInvHistory.put(player, history);
        }
        String name = "";
        name = args.length < 1 ? history : args[0];
        Player target = this.plugin.getServer().getPlayer(name);
        if (target == null && target == null && (target = OpenInv.playerLoader.loadPlayer(name)) == null) {
            sender.sendMessage(ChatColor.RED + "Player " + name + " not found!");
            return true;
        }
        if (!player.hasPermission("OpenInv.override") && target.hasPermission("OpenInv.exempt")) {
            sender.sendMessage(ChatColor.RED + target.getDisplayName() + "'s inventory is protected!");
            return true;
        }
        if (!player.hasPermission("OpenInv.crossworld") && !player.hasPermission("OpenInv.override") && target.getWorld() != player.getWorld()) {
            sender.sendMessage(ChatColor.RED + target.getDisplayName() + " is not in your world!");
            return true;
        }
        if (!player.hasPermission("OpenInv.openself") && target.equals(player)) {
            sender.sendMessage(ChatColor.RED + "You're not allowed to openinv yourself.");
            return true;
        }
        history = target.getName();
        openInvHistory.put(player, history);
        ISpecialPlayerInventory inv = OpenInv.inventories.get(target.getName().toLowerCase());
        if (inv == null) {
            inv = InternalAccessor.Instance.newSpecialPlayerInventory(target, !offline);
        }
        player.openInventory(inv.getBukkitInventory());
        return true;
    }
}

