/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.internal.v1_5_R3;

import com.lishid.openinv.OpenInv;
import com.lishid.openinv.internal.ISpecialPlayerInventory;
import net.minecraft.server.v1_5_R3.EntityHuman;
import net.minecraft.server.v1_5_R3.IInventory;
import net.minecraft.server.v1_5_R3.ItemStack;
import net.minecraft.server.v1_5_R3.PlayerInventory;
import org.bukkit.craftbukkit.v1_5_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_5_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_5_R3.inventory.CraftInventory;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class SpecialPlayerInventory
extends PlayerInventory
implements ISpecialPlayerInventory {
    CraftPlayer owner;
    public boolean playerOnline = false;
    private ItemStack[] extra = new ItemStack[5];
    private CraftInventory inventory = new CraftInventory((IInventory)this);

    public SpecialPlayerInventory(Player p, Boolean online) {
        super((EntityHuman)((CraftPlayer)p).getHandle());
        this.owner = (CraftPlayer)p;
        this.playerOnline = online;
        this.items = this.player.inventory.items;
        this.armor = this.player.inventory.armor;
        OpenInv.inventories.put(this.owner.getName().toLowerCase(), this);
    }

    @Override
    public Inventory getBukkitInventory() {
        return this.inventory;
    }

    @Override
    public void InventoryRemovalCheck() {
        this.owner.saveData();
        if (this.transaction.isEmpty() && !this.playerOnline) {
            OpenInv.inventories.remove(this.owner.getName().toLowerCase());
        }
    }

    @Override
    public void PlayerGoOnline(Player player) {
        if (!this.playerOnline) {
            CraftPlayer p = (CraftPlayer)player;
            p.getHandle().inventory.items = this.items;
            p.getHandle().inventory.armor = this.armor;
            p.saveData();
            this.playerOnline = true;
        }
    }

    @Override
    public void PlayerGoOffline() {
        this.playerOnline = false;
        this.InventoryRemovalCheck();
    }

    public void onClose(CraftHumanEntity who) {
        super.onClose(who);
        this.InventoryRemovalCheck();
    }

    public ItemStack[] getContents() {
        ItemStack[] C = new ItemStack[this.getSize()];
        System.arraycopy(this.items, 0, C, 0, this.items.length);
        System.arraycopy(this.items, 0, C, this.items.length, this.armor.length);
        return C;
    }

    public int getSize() {
        return super.getSize() + 5;
    }

    public ItemStack getItem(int i) {
        ItemStack[] is = this.items;
        if (i >= is.length) {
            i -= is.length;
            is = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= is.length) {
            i -= is.length;
            is = this.extra;
        } else if (is == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        return is[i];
    }

    public ItemStack splitStack(int i, int j) {
        ItemStack[] is = this.items;
        if (i >= is.length) {
            i -= is.length;
            is = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= is.length) {
            i -= is.length;
            is = this.extra;
        } else if (is == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (is[i] != null) {
            if (is[i].count <= j) {
                ItemStack itemstack = is[i];
                is[i] = null;
                return itemstack;
            }
            ItemStack itemstack = is[i].a(j);
            if (is[i].count == 0) {
                is[i] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack splitWithoutUpdate(int i) {
        ItemStack[] is = this.items;
        if (i >= is.length) {
            i -= is.length;
            is = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= is.length) {
            i -= is.length;
            is = this.extra;
        } else if (is == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (is[i] != null) {
            ItemStack itemstack = is[i];
            is[i] = null;
            return itemstack;
        }
        return null;
    }

    public void setItem(int i, ItemStack itemstack) {
        ItemStack[] is = this.items;
        if (i >= is.length) {
            i -= is.length;
            is = this.armor;
        } else {
            i = this.getReversedItemSlotNum(i);
        }
        if (i >= is.length) {
            i -= is.length;
            is = this.extra;
        } else if (is == this.armor) {
            i = this.getReversedArmorSlotNum(i);
        }
        if (is == this.extra) {
            this.owner.getHandle().drop(itemstack);
            itemstack = null;
        }
        is[i] = itemstack;
        this.owner.getHandle().defaultContainer.b();
    }

    private int getReversedItemSlotNum(int i) {
        if (i >= 27) {
            return i - 27;
        }
        return i + 9;
    }

    private int getReversedArmorSlotNum(int i) {
        if (i == 0) {
            return 3;
        }
        if (i == 1) {
            return 2;
        }
        if (i == 2) {
            return 1;
        }
        if (i == 3) {
            return 0;
        }
        return i;
    }

    public String getName() {
        if (this.player.name.length() > 16) {
            return this.player.name.substring(0, 16);
        }
        return this.player.name;
    }

    public boolean a(EntityHuman entityhuman) {
        return true;
    }
}

