/*
 * Decompiled with CFR 0.152.
 */
package com.lishid.openinv.utils;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Updater {
    private static final String[] noUpdateTag = new String[]{"test", "unstable"};
    private static final String DBOUrl = "http://dev.bukkit.org/server-mods/";
    private static final int BYTE_SIZE = 1024;
    private final Plugin plugin;
    private final String slug;
    private volatile long totalSize;
    private volatile int sizeLine;
    private volatile int multiplier;
    private volatile URL url;
    private volatile String updateFolder = YamlConfiguration.loadConfiguration((File)new File("bukkit.yml")).getString("settings.update-folder");
    private volatile UpdateResult result = UpdateResult.SUCCESS;
    private volatile boolean announce = false;
    private volatile UpdateType type;
    private volatile String versionTitle;
    private volatile String versionLink;
    private volatile String versionDownloaded = "";
    private volatile File file;
    private volatile Logger logger;
    private static final String TITLE = "title";
    private static final String LINK = "link";
    private static final String ITEM = "item";

    public Updater(Plugin plugin, Logger logger, String slug, File file) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        Preconditions.checkNotNull((Object)logger, (Object)"logger");
        Preconditions.checkNotNull((Object)slug, (Object)"slug");
        Preconditions.checkNotNull((Object)file, (Object)"file");
        this.plugin = plugin;
        this.file = file;
        this.slug = slug;
        this.logger = logger;
    }

    public synchronized UpdateResult update(UpdateType type) {
        this.type = type;
        try {
            this.url = null;
            this.url = new URL(DBOUrl + this.slug + "/files.rss");
        }
        catch (MalformedURLException ex) {
            this.logger.warning("The author of this plugin has misconfigured their Auto Update system");
            this.logger.warning("The project slug added ('" + this.slug + "') is invalid, and does not exist on dev.bukkit.org");
            this.result = UpdateResult.FAIL_BADSLUG;
        }
        if (this.url != null) {
            this.readFeed();
            if (this.versionTitle != null && !this.versionTitle.equals(this.versionDownloaded) && this.versionCheck(this.versionTitle)) {
                String fileLink = this.getFile(this.versionLink);
                if (fileLink != null && type != UpdateType.NO_DOWNLOAD) {
                    String name = this.file.getName();
                    this.saveFile(new File("plugins/" + this.updateFolder), name, fileLink);
                    this.versionDownloaded = this.versionTitle;
                } else {
                    this.result = UpdateResult.UPDATE_AVAILABLE;
                }
            }
        }
        return this.result;
    }

    public UpdateResult getResult() {
        return this.result;
    }

    public long getFileSize() {
        return this.totalSize;
    }

    public String getLatestVersionString() {
        return this.versionTitle;
    }

    private void saveFile(File folder, String file, String u) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            try {
                int count;
                URL url = new URL(u);
                int fileLength = url.openConnection().getContentLength();
                in = new BufferedInputStream(url.openStream());
                fout = new FileOutputStream(String.valueOf(folder.getAbsolutePath()) + "/" + file);
                byte[] data = new byte[1024];
                if (this.announce) {
                    this.logger.info("About to download a new update: " + this.versionTitle);
                }
                long downloaded = 0L;
                while ((count = in.read(data, 0, 1024)) != -1) {
                    fout.write(data, 0, count);
                    int percent = (int)((downloaded += (long)count) * 100L / (long)fileLength);
                    if (!this.announce || percent % 10 != 0) continue;
                    this.logger.info("Downloading update: " + percent + "% of " + fileLength + " bytes.");
                }
                if (this.announce) {
                    this.logger.info("Finished updating.");
                }
            }
            catch (Exception ex) {
                this.logger.warning("The auto-updater tried to download a new update, but was unsuccessful.");
                this.logger.log(Level.INFO, "Error message to submit as a ticket.", ex);
                this.result = UpdateResult.FAIL_DOWNLOAD;
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean pluginFile(String name) {
        File[] fileArray = new File("plugins").listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getFile(String link) {
        String download = null;
        try {
            String line;
            URL url = new URL(link);
            URLConnection urlConn = url.openConnection();
            InputStreamReader inStream = new InputStreamReader(urlConn.getInputStream());
            BufferedReader buff = new BufferedReader(inStream);
            int counter = 0;
            while ((line = buff.readLine()) != null) {
                ++counter;
                if (line.contains("<li class=\"user-action user-action-download\">")) {
                    download = line.split("<a href=\"")[1].split("\">Download</a>")[0];
                    continue;
                }
                if (line.contains("<dt>Size</dt>")) {
                    this.sizeLine = counter + 1;
                    continue;
                }
                if (counter != this.sizeLine) continue;
                String size = line.replaceAll("<dd>", "").replaceAll("</dd>", "");
                this.multiplier = size.contains("MiB") ? 0x100000 : 1024;
                size = size.replace(" KiB", "").replace(" MiB", "");
                this.totalSize = (long)(Double.parseDouble(size) * (double)this.multiplier);
            }
            urlConn = null;
            inStream = null;
            buff.close();
            buff = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.warning("The auto-updater tried to contact dev.bukkit.org, but was unsuccessful.");
            this.result = UpdateResult.FAIL_DBO;
            return null;
        }
        return download;
    }

    private boolean versionCheck(String title) {
        if (this.type != UpdateType.NO_VERSION_CHECK) {
            String[] parts = title.split(" ");
            String version = this.plugin.getDescription().getVersion();
            if (parts.length >= 2) {
                String remoteVersion = parts[1].split(" ")[0];
                int remVer = -1;
                int curVer = 0;
                try {
                    remVer = this.calVer(remoteVersion);
                    curVer = this.calVer(version);
                }
                catch (NumberFormatException nfe) {
                    remVer = -1;
                }
                if (this.hasTag(version) || version.equalsIgnoreCase(remoteVersion) || curVer >= remVer) {
                    this.result = UpdateResult.NO_UPDATE;
                    return false;
                }
            } else {
                this.logger.warning("The author of this plugin has misconfigured their Auto Update system");
                this.logger.warning("Files uploaded to BukkitDev should contain the version number, seperated from the name by a 'v', such as PluginName v1.0");
                this.logger.warning("Please notify the author (" + (String)this.plugin.getDescription().getAuthors().get(0) + ") of this error.");
                this.result = UpdateResult.FAIL_NOVERSION;
                return false;
            }
        }
        return true;
    }

    private Integer calVer(String s) throws NumberFormatException {
        if (s.contains(".")) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                Character c = Character.valueOf(s.charAt(i));
                if (Character.isLetterOrDigit(c.charValue())) {
                    sb.append(c);
                }
                ++i;
            }
            return Integer.parseInt(sb.toString());
        }
        return Integer.parseInt(s);
    }

    private boolean hasTag(String version) {
        String[] stringArray = noUpdateTag;
        int n = noUpdateTag.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (version.contains(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void readFeed() {
        try {
            String title = "";
            String link = "";
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            InputStream in = this.read();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    if (event.asStartElement().getName().getLocalPart().equals(TITLE)) {
                        event = eventReader.nextEvent();
                        title = event.asCharacters().getData();
                        continue;
                    }
                    if (!event.asStartElement().getName().getLocalPart().equals(LINK)) continue;
                    event = eventReader.nextEvent();
                    link = event.asCharacters().getData();
                    continue;
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(ITEM)) continue;
                this.versionTitle = title;
                this.versionLink = link;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private InputStream read() {
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum UpdateResult {
        SUCCESS(1, "The updater found an update, and has readied it to be loaded the next time the server restarts/reloads."),
        NO_UPDATE(2, "The updater did not find an update, and nothing was downloaded."),
        FAIL_DOWNLOAD(3, "The updater found an update, but was unable to download it."),
        FAIL_DBO(4, "For some reason, the updater was unable to contact dev.bukkit.org to download the file."),
        FAIL_NOVERSION(5, "When running the version check, the file on DBO did not contain the a version in the format 'vVersion' such as 'v1.0'."),
        FAIL_BADSLUG(6, "The slug provided by the plugin running the updater was invalid and doesn't exist on DBO."),
        UPDATE_AVAILABLE(7, "The updater found an update, but because of the UpdateType being set to NO_DOWNLOAD, it wasn't downloaded.");

        private static final Map<Integer, UpdateResult> valueList;
        private final int value;
        private final String description;

        static {
            valueList = new HashMap<Integer, UpdateResult>();
            UpdateResult[] updateResultArray = UpdateResult.values();
            int n = updateResultArray.length;
            int n2 = 0;
            while (n2 < n) {
                UpdateResult result = updateResultArray[n2];
                valueList.put(result.value, result);
                ++n2;
            }
        }

        private UpdateResult(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public int getValue() {
            return this.value;
        }

        public static UpdateResult getResult(int value) {
            return valueList.get(value);
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum UpdateType {
        DEFAULT(1),
        NO_VERSION_CHECK(2),
        NO_DOWNLOAD(3);

        private static final Map<Integer, UpdateType> valueList;
        private final int value;

        static {
            valueList = new HashMap<Integer, UpdateType>();
            UpdateType[] updateTypeArray = UpdateType.values();
            int n = updateTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                UpdateType result = updateTypeArray[n2];
                valueList.put(result.value, result);
                ++n2;
            }
        }

        private UpdateType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static UpdateType getResult(int value) {
            return valueList.get(value);
        }
    }
}

