/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import de.bananaco.bpermissions.api.Calculable;
import de.bananaco.bpermissions.api.CustomNodes;
import de.bananaco.bpermissions.api.MapCalculable;
import de.bananaco.bpermissions.api.Permission;
import de.bananaco.bpermissions.api.RecursiveGroupException;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.api.util.CalculableType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiLayer {
    private static WorldManager wm = WorldManager.getInstance();

    @Deprecated
    public static de.bananaco.bpermissions.api.CalculableType getType(CalculableType type) {
        return type == CalculableType.GROUP ? de.bananaco.bpermissions.api.CalculableType.GROUP : de.bananaco.bpermissions.api.CalculableType.USER;
    }

    @Deprecated
    public static String[] getGroups(String world, CalculableType type, String name) {
        return ApiLayer.getGroups(world, ApiLayer.getType(type), name);
    }

    @Deprecated
    public static Permission[] getPermissions(String world, CalculableType type, String name) {
        return ApiLayer.getPermissions(world, ApiLayer.getType(type), name);
    }

    @Deprecated
    public static synchronized Map<String, Boolean> getEffectivePermissions(String world, CalculableType type, String name) {
        return ApiLayer.getEffectivePermissions(world, ApiLayer.getType(type), name);
    }

    @Deprecated
    public static String getValue(String world, CalculableType type, String name, String key) {
        return ApiLayer.getValue(world, ApiLayer.getType(type), name, key);
    }

    @Deprecated
    public static void addGroup(String world, CalculableType type, String name, String groupToAdd) {
        ApiLayer.addGroup(world, ApiLayer.getType(type), name, groupToAdd);
    }

    @Deprecated
    public static void setGroup(String world, CalculableType type, String name, String groupToAdd) {
        ApiLayer.setGroup(world, ApiLayer.getType(type), name, groupToAdd);
    }

    @Deprecated
    public static void removeGroup(String world, CalculableType type, String name, String groupToRemove) {
        ApiLayer.removeGroup(world, ApiLayer.getType(type), name, groupToRemove);
    }

    @Deprecated
    public static boolean hasGroup(String world, CalculableType type, String name, String group) {
        return ApiLayer.hasGroup(world, ApiLayer.getType(type), name, group);
    }

    @Deprecated
    public static boolean hasGroupRecursive(String world, CalculableType type, String name, String group) {
        return ApiLayer.hasGroupRecursive(world, ApiLayer.getType(type), name, group);
    }

    @Deprecated
    public static void addPermission(String world, CalculableType type, String name, Permission permissionToAdd) {
        ApiLayer.addPermission(world, ApiLayer.getType(type), name, permissionToAdd);
    }

    @Deprecated
    public static void removePermission(String world, CalculableType type, String name, String permissionToRemove) {
        ApiLayer.removePermission(world, ApiLayer.getType(type), name, permissionToRemove);
    }

    @Deprecated
    public static boolean hasPermission(String world, CalculableType type, String name, String node) {
        return ApiLayer.hasPermission(world, ApiLayer.getType(type), name, node);
    }

    @Deprecated
    public static void setValue(String world, CalculableType type, String name, String key, String value) {
        ApiLayer.setValue(world, ApiLayer.getType(type), name, key, value);
    }

    public static String[] getGroups(String world, de.bananaco.bpermissions.api.CalculableType type, String name) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null) {
            return new String[0];
        }
        Calculable c = w.get(name, type);
        List<String> g = c.serialiseGroups(false);
        String[] groups = g.toArray(new String[g.size()]);
        return groups;
    }

    public static Permission[] getPermissions(String world, de.bananaco.bpermissions.api.CalculableType type, String name) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null) {
            return new Permission[0];
        }
        Calculable c = w.get(name, type);
        Set<Permission> p = c.getPermissions();
        Permission[] permissions = p.toArray(new Permission[p.size()]);
        return permissions;
    }

    public static synchronized Map<String, Boolean> getEffectivePermissions(String world, de.bananaco.bpermissions.api.CalculableType type, String name) {
        World w;
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        World global = wm.getWorld(null);
        World world2 = w = world == null ? null : wm.getWorld(world);
        if (wm.getUseGlobalFiles()) {
            try {
                global.get(name, type).calculateEffectivePermissions();
            }
            catch (RecursiveGroupException e) {
                e.printStackTrace();
            }
            permissions.putAll(((MapCalculable)global.get(name, type)).getMappedPermissions());
        }
        if (w != null) {
            try {
                w.get(name, type).calculateEffectivePermissions();
            }
            catch (RecursiveGroupException e) {
                e.printStackTrace();
            }
            permissions.putAll(((MapCalculable)w.get(name, type)).getMappedPermissions());
        }
        for (String key : new HashSet(permissions.keySet())) {
            if (!CustomNodes.contains(key)) continue;
            Map<String, Boolean> children = CustomNodes.getChildren(key);
            if (!((Boolean)permissions.get(key)).booleanValue()) {
                children = Permission.reverse(children);
            }
            permissions.putAll(children);
        }
        return permissions;
    }

    public static boolean update() {
        return wm.update();
    }

    public static String getValue(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String key) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || key == null) {
            return "";
        }
        Calculable c = w.get(name, type);
        String v = c.getEffectiveValue(key);
        if (v.equals("") && wm.getUseGlobalFiles()) {
            w = wm.getDefaultWorld();
            if (w == null) {
                return v;
            }
            c = w.get(name, type);
            v = c.getEffectiveValue(key);
        }
        return v;
    }

    public static void addGroup(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String groupToAdd) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || groupToAdd == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.addGroup(groupToAdd);
    }

    public static void setGroup(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String groupToAdd) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || groupToAdd == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.getGroupsAsString().clear();
        c.addGroup(groupToAdd);
    }

    public static void removeGroup(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String groupToRemove) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || groupToRemove == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.removeGroup(groupToRemove);
    }

    public static boolean hasGroup(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String group) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || group == null) {
            return false;
        }
        Calculable c = w.get(name, type);
        return c.hasGroup(group);
    }

    public static boolean hasGroupRecursive(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String group) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || group == null) {
            return false;
        }
        Calculable c = w.get(name, type);
        return c.hasGroupRecursive(group);
    }

    public static void addPermission(String world, de.bananaco.bpermissions.api.CalculableType type, String name, Permission permissionToAdd) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || permissionToAdd == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.addPermission(permissionToAdd.name(), permissionToAdd.isTrue());
    }

    public static void removePermission(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String permissionToRemove) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || permissionToRemove == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.removePermission(permissionToRemove);
    }

    public static boolean hasPermission(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String node) {
        return Calculable.hasPermission(node, ApiLayer.getEffectivePermissions(world, type, name));
    }

    public static void setValue(String world, de.bananaco.bpermissions.api.CalculableType type, String name, String key, String value) {
        World w = wm.getWorld(world);
        if (w == null || type == null || name == null || key == null) {
            return;
        }
        Calculable c = w.get(name, type);
        c.setValue(key, value);
    }
}

