/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import de.bananaco.bpermissions.api.Calculable;
import de.bananaco.bpermissions.api.CalculableType;
import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.MapCalculable;
import de.bananaco.bpermissions.api.Permission;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.imp.Debugger;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CalculableWrapper
extends MapCalculable {
    private WorldManager wm = WorldManager.getInstance();

    public CalculableWrapper(String name, Set<String> groups, Set<Permission> permissions, String world) {
        super(name, groups, permissions, world);
    }

    @Override
    public boolean hasPermission(String node) {
        node = node.toLowerCase();
        boolean allowed = Calculable.hasPermission(node, this.getMappedPermissions());
        return allowed;
    }

    @Override
    public void addGroup(String group) {
        super.addGroup(group);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void removeGroup(String group) {
        super.removeGroup(group);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void addPermission(String permission, boolean isTrue) {
        super.addPermission(permission, isTrue);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void removePermission(String permission) {
        super.removePermission(permission);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void setValue(String key, String value) {
        super.setValue(key, value);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    @Override
    public void removeKey(String key) {
        super.removeKey(key);
        this.setDirty(true);
        this.setCalculablesWithGroupDirty();
        if (this.wm.getAutoSave()) {
            this.getWorldObject().save();
            this.getWorldObject().setupAll();
        }
    }

    public void setCalculablesWithGroupDirty() {
        Set<Calculable> users = this.getWorldObject().getAll(CalculableType.USER);
        Set<Calculable> groups = this.getWorldObject().getAll(CalculableType.GROUP);
        if (users == null || users.size() == 0) {
            Debugger.log("Error setting users dirty");
        } else {
            for (Calculable user : users) {
                if (!user.hasGroupRecursive(this.getName())) continue;
                ((User)user).setDirty(true);
            }
        }
        if (groups == null || groups.size() == 0) {
            Debugger.log("Error setting groups dirty");
        } else {
            for (Calculable group : groups) {
                if (!group.hasGroupRecursive(this.getName())) continue;
                ((Group)group).setDirty(true);
            }
        }
    }
}

