/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import de.bananaco.bpermissions.api.CalculableType;
import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.Permission;
import de.bananaco.bpermissions.api.PermissionCarrier;
import de.bananaco.bpermissions.api.WorldManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupCarrier
extends PermissionCarrier {
    private final Set<String> groups;

    protected GroupCarrier(Set<String> groups, Set<Permission> permissions, String world) {
        super(permissions, world);
        if (groups == null) {
            groups = new HashSet<String>();
        }
        this.groups = groups;
    }

    public Set<Group> getGroups() {
        HashSet<Group> groups = new HashSet<Group>();
        for (String name : this.groups) {
            if (WorldManager.getInstance().getWorld(this.getWorld()) == null) {
                System.err.println(this.getWorld() + " is null?");
            }
            Group group = (Group)WorldManager.getInstance().getWorld(this.getWorld()).get(name, CalculableType.GROUP);
            groups.add(group);
        }
        return groups;
    }

    public Set<String> getGroupsAsString() {
        return this.groups;
    }

    public void addGroup(String group) {
        group = group.toLowerCase();
        this.groups.add(group);
    }

    public void removeGroup(String group) {
        group = group.toLowerCase();
        this.groups.remove(group);
    }

    public boolean hasGroup(String group) {
        for (String g : this.groups) {
            if (!g.equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }

    public boolean hasGroupRecursive(String group) {
        if (this.groups.contains(group)) {
            return true;
        }
        for (Group g : this.getGroups()) {
            if (!g.hasGroupRecursive(group)) continue;
            return true;
        }
        return false;
    }

    public List<String> serialiseGroups(boolean sort) {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<Group> gr = new ArrayList<Group>(this.getGroups());
        if (sort) {
            GroupCarrier.sortGroups(gr);
        }
        for (int i = 0; i < gr.size(); ++i) {
            groups.add(((Group)gr.get(i)).getNameLowerCase());
        }
        return groups;
    }

    @Override
    public void clear() {
        this.groups.clear();
        super.clear();
    }
}

