/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Permission
extends de.bananaco.bpermissions.api.util.Permission {
    private final boolean isTrue;
    private final String name;
    private final Map<String, Boolean> children;

    public static Set<Permission> loadFromString(List<String> listPerms) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        if (listPerms != null) {
            for (String perm : listPerms) {
                permissions.add(Permission.loadFromString(perm));
            }
        }
        return permissions;
    }

    public static Permission loadFromString(String perm) {
        if (perm.startsWith("^")) {
            return new Permission(perm.replace("^", ""), false);
        }
        if (perm.startsWith("-")) {
            return new Permission(perm.replace("-", ""), false);
        }
        return new Permission(perm, true);
    }

    public static Permission loadWithChildren(String perm, boolean value, Map<String, Boolean> children) {
        if (perm == null || children == null) {
            return null;
        }
        return new Permission(perm, value, children);
    }

    public static Map<String, Boolean> reverse(Map<String, Boolean> perms) {
        HashMap<String, Boolean> newChildren = new HashMap<String, Boolean>();
        for (String key : perms.keySet()) {
            newChildren.put(key, perms.get(key) == false);
        }
        perms.clear();
        perms = newChildren;
        return perms;
    }

    Permission(String name, boolean isTrue) {
        this.name = name;
        this.isTrue = isTrue;
        this.children = null;
    }

    Permission(String name, boolean isTrue, Map<String, Boolean> children) {
        this.name = name;
        this.isTrue = isTrue;
        this.children = new HashMap<String, Boolean>(children);
    }

    public Map<String, Boolean> getChildren() {
        if (this.children == null) {
            return new HashMap<String, Boolean>();
        }
        return new HashMap<String, Boolean>(this.children);
    }

    @Override
    public boolean isTrue() {
        return this.isTrue;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String nameLowerCase() {
        return this.name.toLowerCase();
    }

    public String toString() {
        return this.name + ":" + this.isTrue;
    }

    public int hashCode() {
        return this.nameLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        return object.hashCode() == this.hashCode();
    }
}

