/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import de.bananaco.bpermissions.api.Permission;
import de.bananaco.bpermissions.api.WorldCarrier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PermissionCarrier
extends WorldCarrier {
    private final Set<Permission> permissions;

    protected PermissionCarrier(Set<Permission> permissions, String world) {
        super(world);
        if (permissions == null) {
            permissions = new HashSet<Permission>();
        }
        this.permissions = permissions;
    }

    public void addPermission(String permission, boolean isTrue) {
        this.permissions.add(new Permission(permission, isTrue));
    }

    public void removePermission(String permission) {
        Permission removal = null;
        for (Permission p : this.permissions) {
            if (!p.name().equalsIgnoreCase(permission)) continue;
            removal = p;
        }
        if (removal != null) {
            this.permissions.remove(removal);
        }
    }

    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    public Set<String> getPermissionsAsString() {
        HashSet<String> permissions = new HashSet<String>();
        for (Permission permission : this.getPermissions()) {
            if (permission.isTrue()) {
                permissions.add(permission.name());
                continue;
            }
            permissions.add("^" + permission.name());
        }
        return permissions;
    }

    public List<String> serialisePermissions(boolean sort) {
        ArrayList<String> permissions = new ArrayList<String>(this.getPermissionsAsString());
        if (sort) {
            PermissionCarrier.sort(permissions, sort);
        }
        return permissions;
    }

    @Override
    public void clear() {
        this.permissions.clear();
        super.clear();
    }
}

