/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.api;

import de.bananaco.bpermissions.api.World;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldManager {
    private static WorldManager instance = null;
    private World defaultWorld = null;
    private Map<String, String> mirrors = new HashMap<String, String>();
    Map<String, World> worlds = new HashMap<String, World>();
    private boolean autoSave = false;
    private boolean autoSort = false;
    private boolean useGlobalFiles = false;
    protected boolean loaded = false;

    protected WorldManager() {
    }

    public static WorldManager getInstance() {
        if (instance == null) {
            instance = new WorldManager();
        }
        return instance;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean getAutoSave() {
        return this.autoSave;
    }

    public void setAutoSort(boolean autoSort) {
        this.autoSort = autoSort;
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public void setUseGlobalFiles(boolean useGlobalFiles) {
        this.useGlobalFiles = useGlobalFiles;
    }

    public boolean getUseGlobalFiles() {
        return this.useGlobalFiles;
    }

    public void setMirrors(Map<String, String> mirrors) {
        this.mirrors = mirrors;
    }

    public void setDefaultWorld(World world) {
        this.defaultWorld = world;
    }

    public World getDefaultWorld() {
        return this.defaultWorld;
    }

    public World getWorld(String name) {
        if (name == null) {
            return this.getDefaultWorld();
        }
        if (name.equals("*")) {
            return this.getDefaultWorld();
        }
        if (this.mirrors.containsKey(name = name.toLowerCase())) {
            name = this.mirrors.get(name);
        }
        return this.worlds.get(name);
    }

    public boolean containsWorld(String name) {
        if (name == null) {
            return false;
        }
        if (this.mirrors.containsKey(name = name.toLowerCase())) {
            name = this.mirrors.get(name);
        }
        return this.worlds.containsKey(name);
    }

    public Set<World> getAllWorlds() {
        HashSet<World> worlds = new HashSet<World>();
        for (String key : this.worlds.keySet()) {
            if (this.mirrors.containsKey(key)) continue;
            worlds.add(this.worlds.get(key));
        }
        if (this.useGlobalFiles && this.getDefaultWorld() != null) {
            worlds.add(this.getDefaultWorld());
        }
        return worlds;
    }

    public void createWorld(String name, World world) {
        if (this.mirrors.containsKey(name = name.toLowerCase())) {
            return;
        }
        if (name.equals("*")) {
            return;
        }
        this.worlds.put(name, world);
        world.load();
    }

    public void cleanup() {
        for (World world : this.getAllWorlds()) {
            world.cleanup();
        }
    }

    public void saveAll() {
        for (World world : this.getAllWorlds()) {
            world.save();
        }
    }

    public boolean update() {
        try {
            for (World w : this.getAllWorlds()) {
                w.setupAll();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

