/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.imp.Permissions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BukkitCompat {
    public static PermissionAttachment setPermissions(Permissible p, Plugin plugin, Map<String, Boolean> perm) {
        try {
            return BukkitCompat.doBukkitPermissions(p, plugin, perm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PermissionAttachment doBukkitPermissions(Permissible p, Plugin plugin, Map<String, Boolean> permissions) {
        Player player = (Player)p;
        Permission positive = plugin.getServer().getPluginManager().getPermission(player.getName());
        Permission negative = plugin.getServer().getPluginManager().getPermission("^" + player.getName());
        if (positive != null) {
            plugin.getServer().getPluginManager().removePermission(positive);
        }
        if (negative != null) {
            plugin.getServer().getPluginManager().removePermission(negative);
        }
        HashMap<String, Boolean> po = new HashMap<String, Boolean>();
        HashMap<String, Boolean> ne = new HashMap<String, Boolean>();
        for (String key : permissions.keySet()) {
            if (permissions.get(key).booleanValue()) {
                po.put(key, true);
                continue;
            }
            ne.put(key, false);
        }
        positive = new Permission(player.getName(), PermissionDefault.FALSE, po);
        negative = new Permission("^" + player.getName(), PermissionDefault.FALSE, ne);
        plugin.getServer().getPluginManager().addPermission(positive);
        plugin.getServer().getPluginManager().addPermission(negative);
        PermissionAttachment att = null;
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getAttachment() == null || pai.getAttachment().getPlugin() == null || !(pai.getAttachment().getPlugin() instanceof Permissions)) continue;
            att = pai.getAttachment();
            break;
        }
        if (att == null) {
            att = player.addAttachment(plugin);
            att.setPermission(player.getName(), true);
            att.setPermission("^" + player.getName(), true);
        }
        player.recalculatePermissions();
        return att;
    }

    public static void runTest(Player player, Plugin plugin) {
        HashMap<String, Boolean> permissions = new HashMap<String, Boolean>();
        HashSet keys = new HashSet(permissions.keySet());
        for (int i = 0; i < 10000; ++i) {
            permissions.put("example." + String.valueOf(i), true);
        }
        long start = System.currentTimeMillis();
        PermissionAttachment att = player.addAttachment(plugin);
        for (String key : permissions.keySet()) {
            att.setPermission(key, ((Boolean)permissions.get(key)).booleanValue());
        }
        long finish = System.currentTimeMillis();
        long time = finish - start;
        System.out.println("SuperPermissions default took: " + time + "ms.");
        if (!player.hasPermission("example.1")) {
            System.err.println("permissions not registered!");
        }
        for (String key : keys) {
            att.unsetPermission(key);
        }
        att.remove();
        if (player.hasPermission("example.1")) {
            System.err.println("permissions not unregistered!");
        }
        start = System.currentTimeMillis();
        att = BukkitCompat.doBukkitPermissions((Permissible)player, plugin, permissions);
        finish = System.currentTimeMillis();
        time = finish - start;
        if (!player.hasPermission("example.1")) {
            System.err.println("permissions not registered!");
        }
        att.unsetPermission(player.getName());
        att.remove();
        System.out.println("SuperPermissions hack took: " + time + "ms.");
        if (player.hasPermission("example.1")) {
            System.err.println("permissions not unregistered!");
        }
        start = System.currentTimeMillis();
        att = BukkitCompat.setPermissions((Permissible)player, plugin, permissions);
        finish = System.currentTimeMillis();
        time = finish - start;
        if (!player.hasPermission("example.1")) {
            System.err.println("permissions not registered!");
        }
        System.out.println("bPermissions default took: " + time + "ms.");
        for (String key : keys) {
            att.unsetPermission(key);
        }
        att.remove();
        if (player.hasPermission("example.1")) {
            System.err.println("permissions not unregistered!");
        }
    }
}

