/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.Calculable;
import de.bananaco.bpermissions.api.CalculableType;
import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.Permission;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.imp.Permissions;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commands {
    private final WorldManager instance = WorldManager.getInstance();
    private de.bananaco.bpermissions.api.World world = null;
    private CalculableType calc = null;
    private String name = null;

    protected Commands() {
        if (Bukkit.getServer().getWorlds().size() == 1) {
            this.world = this.instance.getWorld(((World)Bukkit.getServer().getWorlds().get(0)).getName());
        }
    }

    protected String format(String message) {
        return Permissions.format(message);
    }

    public void setWorld(String w, CommandSender sender) {
        de.bananaco.bpermissions.api.World world = this.instance.getWorld(w);
        if (world == null) {
            sender.sendMessage(this.format("Please select a loaded world!"));
            return;
        }
        if (!world.equals(this.world)) {
            this.calc = null;
        }
        this.world = world;
        sender.sendMessage(this.format("Set selected world to " + world.getName()));
    }

    public de.bananaco.bpermissions.api.World getWorld() {
        return this.world;
    }

    public void setCalculable(CalculableType type, String c, CommandSender sender) {
        if (this.world == null) {
            sender.sendMessage(this.format("Please select a loaded world!"));
            return;
        }
        this.calc = type;
        this.name = c;
        sender.sendMessage(this.format(this.getCalculable().getName() + " selected."));
    }

    public Calculable getCalculable() {
        if (this.name == null) {
            return null;
        }
        if (this.calc == null) {
            return null;
        }
        return this.world.get(this.name, this.calc);
    }

    public void addGroup(String group, CommandSender sender) {
        this.getCalculable().addGroup(group);
        sender.sendMessage(this.format("Added " + group + " to " + this.getCalculable().getName()));
    }

    public void removeGroup(String group, CommandSender sender) {
        this.getCalculable().removeGroup(group);
        sender.sendMessage(this.format("Removed " + group + " from " + this.getCalculable().getName()));
    }

    public void setGroup(String group, CommandSender sender) {
        this.getCalculable().getGroupsAsString().clear();
        this.getCalculable().addGroup(group);
        sender.sendMessage(this.format("Set " + this.getCalculable().getName() + "'s group to " + group));
    }

    public void listGroups(CommandSender sender) {
        List<String> groups = this.getCalculable().serialiseGroups(this.instance.getAutoSort());
        Object[] gr = groups.toArray(new String[groups.size()]);
        String mgr = Arrays.toString(gr);
        sender.sendMessage(this.format("The " + this.getCalculable().getType().getName() + " " + this.getCalculable().getName() + " has these groups:"));
        sender.sendMessage(mgr);
    }

    public void addPermission(String permission, CommandSender sender) {
        Permission perm = Permission.loadFromString(permission);
        this.getCalculable().addPermission(perm.name(), perm.isTrue());
        sender.sendMessage(this.format("Added " + perm.toString() + " to " + this.getCalculable().getName()));
    }

    public void removePermission(String permission, CommandSender sender) {
        this.getCalculable().removePermission(permission);
        sender.sendMessage(this.format("Removed " + permission + " from " + this.getCalculable().getName()));
    }

    public void listPermissions(CommandSender sender) {
        List<String> permissions = this.getCalculable().serialisePermissions(this.instance.getAutoSort());
        Object[] pr = permissions.toArray(new String[permissions.size()]);
        String mpr = Arrays.toString(pr);
        sender.sendMessage(this.format("The " + this.getCalculable().getType().getName() + " " + this.getCalculable().getName() + " has these permissions:"));
        sender.sendMessage(mpr);
    }

    public void hasPermission(String node, CommandSender sender) {
        Calculable c = this.getCalculable();
        if (c instanceof User) {
            User user = (User)c;
            sender.sendMessage(this.format(user.getName() + " - " + node + ": " + user.hasPermission(node)));
            Player player = Bukkit.getPlayer((String)user.getName());
            if (player != null) {
                sender.sendMessage(this.format("SUPERPERMS - " + node + ": " + player.hasPermission(node)));
            }
        } else if (c instanceof Group) {
            Group group = (Group)c;
            sender.sendMessage(this.format(group.getName() + " - " + node + ": " + group.hasPermission(node)));
        }
    }

    public void setValue(String key, String value, CommandSender sender) {
        this.getCalculable().setValue(key, value);
        sender.sendMessage(this.format(key + " set to " + value + " for " + this.getCalculable().getName()));
    }

    public void showValue(String key, CommandSender sender) {
        String value = this.getCalculable().getValue(key);
        sender.sendMessage(this.format("Meta for " + this.calc.getName() + " " + this.getCalculable().getName() + " - " + key + ": " + value));
    }

    public void save() {
        WorldManager.getInstance().saveAll();
    }

    public void clearMeta(String value, CommandSender sender) {
        this.getCalculable().removeKey(value);
        sender.sendMessage(this.format("Meta for " + this.calc.getName() + " " + this.getCalculable().getName() + " - cleared"));
    }
}

