/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.Permission;
import de.bananaco.bpermissions.imp.YamlConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.permissions.PermissionDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomNodes {
    private final File file = new File("plugins/bPermissions/custom_nodes.yml");
    private YamlConfiguration config;
    private PermissionDefault pdo = PermissionDefault.OP;

    public void load() {
        try {
            List<Permission> permissions = this.doLoad();
            de.bananaco.bpermissions.api.CustomNodes.loadNodes(permissions);
            for (int i = 0; i < permissions.size(); ++i) {
                if (Bukkit.getServer().getPluginManager().getPermission(permissions.get(i).nameLowerCase()) != null) continue;
                Bukkit.getServer().getPluginManager().addPermission(this.convert(permissions.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public org.bukkit.permissions.Permission convert(Permission perm) {
        String name = perm.nameLowerCase();
        Map<String, Boolean> children = perm.getChildren();
        return new org.bukkit.permissions.Permission(name, this.pdo, children);
    }

    private List<Permission> doLoad() throws Exception {
        this.config = new YamlConfiguration();
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
        }
        this.config.load(this.file);
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        Set keys = this.config.getKeys(true);
        if (keys != null && keys.size() > 0) {
            for (String key : keys) {
                String permission = key;
                List childList = this.config.getStringList(permission);
                if (childList == null || childList.size() <= 0) continue;
                HashMap<String, Boolean> children = new HashMap<String, Boolean>();
                Set<Permission> perms = Permission.loadFromString(childList);
                for (Permission perm : perms) {
                    children.put(perm.nameLowerCase(), perm.isTrue());
                }
                permission = permission.replace("permissions.", "");
                Permission perm = Permission.loadWithChildren(permission.toLowerCase(), true, children);
                permissions.add(perm);
            }
        }
        return permissions;
    }
}

