/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.Calculable;
import de.bananaco.bpermissions.api.CalculableType;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Debugger {
    private static Debugger instance = new Debugger();
    private static WorldManager wmInstance = WorldManager.getInstance();
    private boolean debug = false;

    public static boolean setDebug(boolean debug) {
        Debugger.instance.debug = debug;
        return debug;
    }

    public static boolean getDebug() {
        return Debugger.instance.debug;
    }

    public static void log(String message) {
        if (Debugger.instance.debug) {
            System.out.println("[debug] " + message);
        }
    }

    public static void log(World world) {
        String pss;
        String grp;
        String name;
        Object[] pa;
        List<String> ps;
        Object[] ga;
        List<String> gs;
        if (world == null) {
            Debugger.log("No world by that name");
            return;
        }
        Set<Calculable> groups = world.getAll(CalculableType.GROUP);
        Set<Calculable> users = world.getAll(CalculableType.USER);
        Debugger.log("World: " + world.getName());
        Debugger.log(groups.size() + " groups and " + users.size() + " users");
        Debugger.log("** PRINTING GROUP DEBUGGING INFO **");
        for (Calculable group : groups) {
            gs = group.serialiseGroups(wmInstance.getAutoSort());
            ga = gs.toArray(new String[gs.size()]);
            ps = group.serialisePermissions(wmInstance.getAutoSort());
            pa = ps.toArray(new String[ps.size()]);
            name = group.getName();
            grp = Arrays.toString(ga);
            pss = Arrays.toString(pa);
            Debugger.log("Printing info for " + name);
            Debugger.log("Permissions");
            Debugger.log(pss);
            Debugger.log("Groups");
            Debugger.log(grp);
        }
        Debugger.log("** PRINTING USER DEBUGGING INFO **");
        for (Calculable user : users) {
            gs = user.serialiseGroups(wmInstance.getAutoSort());
            ga = gs.toArray(new String[gs.size()]);
            ps = user.serialisePermissions(wmInstance.getAutoSort());
            pa = ps.toArray(new String[ps.size()]);
            name = user.getName();
            grp = Arrays.toString(ga);
            pss = Arrays.toString(pa);
            Debugger.log("Printing info for " + name);
            Debugger.log("Permissions");
            Debugger.log(pss);
            Debugger.log("Groups");
            Debugger.log(grp);
        }
    }
}

