/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.permissions.interfaces.PromotionTrack;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiGroupPromotion
implements PromotionTrack {
    private final File tracks = new File("plugins/bPermissions/tracks.yml");
    private final WorldManager wm = WorldManager.getInstance();
    private YamlConfiguration config = new YamlConfiguration();
    Map<String, List<String>> trackmap = new HashMap<String, List<String>>();

    @Override
    public void load() {
        try {
            this.config = new YamlConfiguration();
            this.trackmap.clear();
            if (!this.tracks.exists()) {
                this.tracks.getParentFile().mkdirs();
                this.tracks.createNewFile();
            }
            this.config.load(this.tracks);
            if (this.config.getKeys(false) == null || this.config.getKeys(false).size() == 0) {
                ArrayList<String> defTrack = new ArrayList<String>();
                defTrack.add("default");
                defTrack.add("moderator");
                defTrack.add("admin");
                this.config.set("default", defTrack);
                this.config.save(this.tracks);
            } else {
                Set keys = this.config.getKeys(false);
                HashMap<String, Boolean> children = new HashMap<String, Boolean>();
                if (keys != null && keys.size() > 0) {
                    for (String key : keys) {
                        children.put("tracks." + key.toLowerCase(), true);
                        List groups = this.config.getStringList(key);
                        if (groups == null || groups.size() <= 0) continue;
                        this.trackmap.put(key.toLowerCase(), groups);
                    }
                }
                Permission perm = new Permission("tracks.*", PermissionDefault.OP, children);
                Bukkit.getPluginManager().addPermission(perm);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void promote(String player, String track, String world) {
        List<String> groups = this.trackmap.get(track.toLowerCase());
        if (world == null) {
            for (World w : this.wm.getAllWorlds()) {
                User user = w.getUser(player);
                boolean promoted = false;
                for (int i = 0; i < groups.size() && !promoted; ++i) {
                    if (user.getGroupsAsString().contains(groups.get(i))) continue;
                    user.addGroup(groups.get(i));
                    promoted = true;
                    w.save();
                }
            }
        } else {
            User user = this.wm.getWorld(world).getUser(player);
            boolean promoted = false;
            for (int i = 0; i < groups.size() && !promoted; ++i) {
                if (user.getGroupsAsString().contains(groups.get(i))) continue;
                user.addGroup(groups.get(i));
                promoted = true;
                this.wm.getWorld(world).save();
            }
        }
    }

    @Override
    public void demote(String player, String track, String world) {
        List<String> groups = this.trackmap.get(track.toLowerCase());
        if (world == null) {
            for (World w : this.wm.getAllWorlds()) {
                User user = w.getUser(player);
                boolean demoted = false;
                for (int i = groups.size() - 1; i > 0 && !demoted; --i) {
                    if (!user.getGroupsAsString().contains(groups.get(i))) continue;
                    user.removeGroup(groups.get(i));
                    demoted = true;
                    w.save();
                }
            }
        } else {
            User user = this.wm.getWorld(world).getUser(player);
            boolean demoted = false;
            for (int i = groups.size() - 1; i > 0 && !demoted; --i) {
                if (!user.getGroupsAsString().contains(groups.get(i))) continue;
                user.removeGroup(groups.get(i));
                demoted = true;
                this.wm.getWorld(world).save();
            }
        }
    }

    @Override
    public boolean containsTrack(String track) {
        return this.trackmap.containsKey(track.toLowerCase());
    }

    @Override
    public List<String> getGroups(String track) {
        return this.config.getStringList(track);
    }
}

