/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.Calculable;
import de.bananaco.bpermissions.api.CalculableType;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.imp.BukkitCompat;
import de.bananaco.bpermissions.imp.Commands;
import de.bananaco.bpermissions.imp.Config;
import de.bananaco.bpermissions.imp.CustomNodes;
import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.DefaultWorld;
import de.bananaco.bpermissions.imp.ExtraCommands;
import de.bananaco.bpermissions.imp.Mirrors;
import de.bananaco.bpermissions.imp.SuperPermissionHandler;
import de.bananaco.bpermissions.imp.ValidityCheck;
import de.bananaco.bpermissions.imp.WorldLoader;
import de.bananaco.bpermissions.imp.loadmanager.MainThread;
import de.bananaco.bpermissions.imp.loadmanager.TaskRunnable;
import de.bananaco.bpermissions.unit.PermissionsTest;
import de.bananaco.permissions.ImportManager;
import de.bananaco.permissions.fornoobs.BackupPermissionsCommand;
import de.bananaco.permissions.fornoobs.ForNoobs;
import de.bananaco.permissions.interfaces.PromotionTrack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Permissions
extends JavaPlugin {
    private final Map<String, String> mirrors = new HashMap<String, String>();
    private final Mirrors mrs = new Mirrors(this.mirrors);
    public SuperPermissionHandler handler;
    private Listener loader;
    public Map<String, Commands> commands;
    private WorldManager wm;
    private DefaultWorld world;
    private Config config;
    protected static JavaPlugin instance = null;
    private MainThread mt;

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        this.mt.setRunning(false);
        System.out.println(Permissions.blankFormat("Disabled"));
    }

    public void onLoad() {
        this.mrs.load();
    }

    public void onEnable() {
        this.mt = MainThread.getInstance();
        this.mt.start();
        instance = this;
        this.config = new Config();
        this.config.load();
        boolean onlineMode = this.getServer().getOnlineMode();
        if (!this.config.getAllowOfflineMode() && !onlineMode) {
            System.err.println(Permissions.blankFormat("Please check config.yml to enable offline-mode use"));
            this.setEnabled(false);
            return;
        }
        this.wm = WorldManager.getInstance();
        this.wm.setUseGlobalFiles(this.config.getUseGlobalFiles());
        this.wm.setAutoSort(this.config.getAutoSorting());
        this.handler = new SuperPermissionHandler(this);
        this.loader = new WorldLoader(this, this.mirrors);
        this.world = new DefaultWorld(this);
        this.wm.setDefaultWorld(this.world);
        this.world.load();
        this.commands = new HashMap<String, Commands>();
        this.getServer().getPluginManager().registerEvents(this.loader, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.handler, (Plugin)this);
        new CustomNodes().load();
        Debugger.log(Permissions.blankFormat("Enabled"));
        this.mt.setStarted(true);
        final DefaultWorld world = this.world;
        this.mt.schedule(new TaskRunnable(){

            public void run() {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance, new Runnable(){

                    public void run() {
                        world.setupAll();
                    }
                }, 0L);
            }

            public TaskRunnable.TaskType getType() {
                return TaskRunnable.TaskType.SERVER;
            }
        });
    }

    public static void printDinosaurs() {
        String dino = "            __ \n           / _)\n    .-^^^-/ /  \n __/       /\n<__.|_|-|_|\n==DINOSAUR==";
        System.out.println("\n" + dino);
    }

    public static String blankFormat(String message) {
        return "[bPermissions] " + message;
    }

    public static String format(String message) {
        ChatColor vary = ChatColor.GREEN;
        if (message.contains("!")) {
            vary = ChatColor.RED;
        } else if (message.contains(":")) {
            vary = ChatColor.AQUA;
        }
        return ChatColor.BLUE + "[bPermissions] " + vary + message;
    }

    public static boolean hasPermission(Player player, String node) {
        return WorldManager.getInstance().getWorld(player.getWorld().getName()).getUser(player.getName()).hasPermission(node);
    }

    public void sendMessage(CommandSender sender, String message) {
        sender.sendMessage(Permissions.format(message));
    }

    public boolean has(CommandSender sender, String perm) {
        if (sender instanceof Player) {
            return sender.hasPermission(perm);
        }
        return true;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String world;
        String value;
        String action;
        CalculableType type;
        String name;
        boolean allowed = true;
        if (sender instanceof Player) {
            boolean bl = allowed = Permissions.hasPermission((Player)sender, "bPermissions.admin") || sender.isOp();
        }
        if (args.length > 0 && (command.getName().equalsIgnoreCase("promote") || command.getName().equalsIgnoreCase("demote"))) {
            String player = args[0];
            String name2 = "default";
            String world2 = null;
            if (args.length > 1) {
                name2 = args[1];
            }
            if (args.length > 2) {
                world2 = args[2];
            }
            if (!this.has(sender, "tracks." + name2)) {
                this.sendMessage(sender, "You don't have permission to use promotion tracks!");
                return true;
            }
            if (command.getName().equalsIgnoreCase("promote")) {
                PromotionTrack track = this.config.getPromotionTrack();
                if (track.containsTrack(name2)) {
                    if (this.config.trackLimit()) {
                        Player s;
                        boolean isValid = true;
                        Player player2 = s = sender instanceof Player ? (Player)sender : null;
                        if (world2 == null) {
                            for (org.bukkit.World w : Bukkit.getWorlds()) {
                                boolean v = new ValidityCheck(s, track, name2, player, w.getName()).isValid();
                                if (v) continue;
                                isValid = false;
                            }
                        } else {
                            isValid = new ValidityCheck(s, track, name2, player, world2).isValid();
                        }
                        if (!isValid) {
                            sender.sendMessage(ChatColor.RED + "Invalid promotion!");
                            return true;
                        }
                    }
                    track.promote(player, name2, world2);
                    this.sendMessage(sender, "Promoted along the track: " + name2 + " in " + (world2 == null ? "all worlds" : "world: " + world2));
                    this.showPromoteOutput(sender, player);
                } else {
                    this.sendMessage(sender, "That track (" + name2 + ") does not exist");
                }
            } else if (command.getName().equalsIgnoreCase("demote")) {
                PromotionTrack track = this.config.getPromotionTrack();
                if (track.containsTrack(name2)) {
                    if (this.config.trackLimit()) {
                        Player s;
                        boolean isValid = true;
                        Player player3 = s = sender instanceof Player ? (Player)sender : null;
                        if (world2 == null) {
                            for (org.bukkit.World w : Bukkit.getWorlds()) {
                                boolean v = new ValidityCheck(s, track, name2, player, w.getName()).isValid();
                                if (v) continue;
                                isValid = false;
                            }
                        } else {
                            isValid = new ValidityCheck(s, track, name2, player, world2).isValid();
                        }
                        if (!isValid) {
                            sender.sendMessage(ChatColor.RED + "Invalid promotion!");
                            return true;
                        }
                    }
                    track.demote(player, name2, world2);
                    this.sendMessage(sender, "Demoted along the track: " + name2 + " in " + (world2 == null ? "all worlds" : "world: " + world2));
                    this.showPromoteOutput(sender, player);
                } else {
                    this.sendMessage(sender, "That track (" + name2 + ") does not exist");
                }
            }
            return true;
        }
        if (!allowed) {
            this.sendMessage(sender, "You're not allowed to do that!");
            return true;
        }
        if (!this.commands.containsKey(this.getName(sender))) {
            this.commands.put(this.getName(sender), new Commands());
        }
        Commands cmd = this.commands.get(this.getName(sender));
        if (command.getName().equalsIgnoreCase("world")) {
            World world3 = cmd.getWorld();
            if (args.length == 0) {
                if (world3 == null) {
                    this.sendMessage(sender, "No world selected.");
                } else {
                    this.sendMessage(sender, "Currently selected world: " + world3.getName());
                }
            } else if (args.length == 1) {
                cmd.setWorld(args[0], sender);
            } else if (args.length == 3 && args[0].equalsIgnoreCase("mirror")) {
                String worldFrom = args[1];
                String worldTo = args[2];
                this.mirrors.put(worldFrom, worldTo);
                this.mrs.save();
                sender.sendMessage(worldFrom + " mirrored to " + worldTo);
            } else {
                this.sendMessage(sender, "Too many arguments.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("user") || command.getName().equalsIgnoreCase("group")) {
            CalculableType opposite;
            Calculable calc = cmd.getCalculable();
            CalculableType type2 = command.getName().equalsIgnoreCase("user") ? CalculableType.USER : CalculableType.GROUP;
            CalculableType calculableType = opposite = !command.getName().equalsIgnoreCase("user") ? CalculableType.USER : CalculableType.GROUP;
            if (args.length == 0) {
                if (calc == null) {
                    this.sendMessage(sender, "Nothing is selected!");
                } else {
                    this.sendMessage(sender, "Currently selected " + calc.getType().getName() + ": " + calc.getName());
                }
            } else if (args.length == 1) {
                cmd.setCalculable(type2, args[0], sender);
            } else if (args.length == 2) {
                if (calc == null) {
                    this.sendMessage(sender, "Nothing is selected!");
                } else if (calc.getType() != type2) {
                    this.sendMessage(sender, "Please select a " + type2.getName() + ", you currently have a " + opposite.getName() + " selected.");
                } else {
                    String action2 = args[0];
                    String value2 = args[1];
                    if (action2.equalsIgnoreCase("addgroup")) {
                        cmd.addGroup(value2, sender);
                    } else if (action2.equalsIgnoreCase("rmgroup")) {
                        cmd.removeGroup(value2, sender);
                    } else if (action2.equalsIgnoreCase("setgroup")) {
                        cmd.setGroup(value2, sender);
                    } else if (action2.equalsIgnoreCase("list")) {
                        if ((value2 = value2.toLowerCase()).equalsIgnoreCase("groups") || value2.equalsIgnoreCase("group") || value2.equalsIgnoreCase("g")) {
                            cmd.listGroups(sender);
                        } else if (value2.startsWith("perm") || value2.equalsIgnoreCase("p")) {
                            cmd.listPermissions(sender);
                        }
                    } else if (action2.equalsIgnoreCase("meta")) {
                        cmd.showValue(value2, sender);
                    } else if (action2.equalsIgnoreCase("cmeta")) {
                        cmd.clearMeta(value2, sender);
                    } else if (action2.equalsIgnoreCase("addperm")) {
                        cmd.addPermission(value2, sender);
                    } else if (action2.equalsIgnoreCase("rmperm")) {
                        cmd.removePermission(value2, sender);
                    } else if (action2.equals("has")) {
                        cmd.hasPermission(value2, sender);
                    } else {
                        this.sendMessage(sender, "Please consult the command documentation!");
                    }
                }
            } else if (args.length == 3 && args[0].equalsIgnoreCase("meta")) {
                if (calc == null) {
                    this.sendMessage(sender, "Nothing is selected!");
                } else if (calc.getType() != type2) {
                    this.sendMessage(sender, "Please select a " + type2.getName() + ", you currently have a " + opposite.getName() + " selected.");
                } else {
                    cmd.setValue(args[1], args[2], sender);
                }
            } else if (args.length > 3 && args[0].equalsIgnoreCase("meta")) {
                if (calc == null) {
                    this.sendMessage(sender, "Nothing is selected!");
                } else if (calc.getType() != type2) {
                    this.sendMessage(sender, "Please select a " + type2.getName() + ", you currently have a " + opposite.getName() + " selected.");
                } else {
                    StringBuilder prefixMaker = new StringBuilder();
                    for (int i = 2; i < args.length; ++i) {
                        prefixMaker.append(args[i]);
                        if (i == args.length - 1) continue;
                        prefixMaker.append(" ");
                    }
                    String prefix = prefixMaker.toString();
                    cmd.setValue(args[1], prefix, sender);
                }
            } else {
                this.sendMessage(sender, "Too many arguments.");
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("exec")) {
            name = "null";
            type = CalculableType.USER;
            action = "null";
            value = "null";
            world = null;
            for (String c : args) {
                if (c.startsWith("u:") || c.startsWith("g:")) {
                    type = c.startsWith("u:") ? CalculableType.USER : CalculableType.GROUP;
                    name = c.split(":")[1];
                    continue;
                }
                if (c.startsWith("a:")) {
                    action = c.split(":")[1];
                    continue;
                }
                if (c.startsWith("v:")) {
                    value = c.split(":")[1];
                    continue;
                }
                if (!c.startsWith("w:")) continue;
                world = c.split(":")[1];
            }
            String message = ChatColor.GOLD + "Executing action: " + ChatColor.GREEN + action + " " + value + ChatColor.GOLD + " in " + ChatColor.GREEN + (world == null ? "all worlds" : "world: " + world);
            String message2 = ChatColor.GOLD + "Action applied to " + ChatColor.GREEN + type.getName() + " " + name;
            sender.sendMessage(message);
            sender.sendMessage(message2);
            ExtraCommands.execute(name, type, action, value, world);
        }
        if (command.getName().equalsIgnoreCase("setgroup")) {
            if (args.length < 2) {
                this.sendMessage(sender, "Not enough arguments!");
                return false;
            }
            name = args[0];
            type = CalculableType.USER;
            action = "setgroup";
            value = args[1];
            world = null;
            ExtraCommands.execute(name, type, action, value, world);
            this.sendMessage(sender, "The player " + name + " is now " + value + "!");
        }
        if (command.getName().equalsIgnoreCase("permissions")) {
            if (args.length == 2 && args[0].equalsIgnoreCase("import")) {
                sender.sendMessage("Importing from " + args[1]);
                try {
                    if (args[1].equalsIgnoreCase("yml")) {
                        new ImportManager(this).importYML();
                    }
                    if (args[1].equalsIgnoreCase("pex")) {
                        new ImportManager(this).importPEX();
                    }
                    if (args[1].equalsIgnoreCase("p3")) {
                        new ImportManager(this).importPermissions3();
                    }
                    if (args[1].equalsIgnoreCase("gm")) {
                        new ImportManager(this).importGroupManager();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            if (args.length == 1) {
                String action3;
                if (sender instanceof ConsoleCommandSender) {
                    Player[] players;
                    if (args[0].equalsIgnoreCase("debug")) {
                        if (Debugger.getDebug()) {
                            for (World world4 : this.wm.getAllWorlds()) {
                                Debugger.log(world4);
                            }
                            return true;
                        }
                        sender.sendMessage("Please enable debug mode to use this command.");
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("debugperms")) {
                        players = Bukkit.getOnlinePlayers();
                        if (players.length == 0) {
                            System.err.println("You need some online players!");
                        } else {
                            for (Player player : players) {
                                PermissionsTest.test(player);
                            }
                        }
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("debugset")) {
                        players = Bukkit.getOnlinePlayers();
                        if (players.length == 0) {
                            System.err.println("You need some online players!");
                        } else {
                            Player player = players[0];
                            BukkitCompat.runTest(player, (Plugin)this);
                        }
                        return true;
                    }
                }
                if ((action3 = args[0]).equalsIgnoreCase("save")) {
                    this.sendMessage(sender, "All worlds saved!");
                    cmd.save();
                    return true;
                }
                if (action3.equalsIgnoreCase("reload")) {
                    for (World world5 : this.wm.getAllWorlds()) {
                        world5.load();
                    }
                    this.mt.schedule(new TaskRunnable(){

                        public void run() {
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)instance, new Runnable(){

                                public void run() {
                                    Permissions.this.world.setupAll();
                                }
                            }, 0L);
                        }

                        public TaskRunnable.TaskType getType() {
                            return TaskRunnable.TaskType.SERVER;
                        }
                    });
                    this.sendMessage(sender, "All worlds reloading!");
                    return true;
                }
                if (action3.equalsIgnoreCase("cleanup")) {
                    this.sendMessage(sender, "Cleaning up files!");
                    this.wm.cleanup();
                    return true;
                }
                if (action3.equalsIgnoreCase("examplefiles")) {
                    this.sendMessage(sender, "Created example files!");
                    new ForNoobs(this).addAll();
                    return true;
                }
                if (action3.equalsIgnoreCase("backup")) {
                    this.sendMessage(sender, "Creating backup!");
                    new BackupPermissionsCommand(this).backup();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void showPromoteOutput(CommandSender sender, String player) {
        sender.sendMessage("The player: " + ChatColor.GREEN + player + ChatColor.WHITE + " now has these groups");
        for (World world : WorldManager.getInstance().getAllWorlds()) {
            List<String> groups = world.getUser(player).serialiseGroups(this.config.getAutoSorting());
            Object[] g = groups.toArray(new String[groups.size()]);
            String gr = Arrays.toString(g);
            sender.sendMessage("In world: " + world.getName() + " " + gr);
        }
    }

    private String getName(CommandSender sender) {
        if (sender instanceof Player) {
            return sender.getName();
        }
        return "CONSOLE";
    }
}

