/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.ApiLayer;
import de.bananaco.bpermissions.api.CalculableType;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.imp.BukkitCompat;
import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.Permissions;
import de.bananaco.bpermissions.imp.loadmanager.MainThread;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperPermissionHandler
implements Listener {
    private WorldManager wm = WorldManager.getInstance();
    private Permissions plugin;

    public static synchronized void setPermissions(Permissible p, Plugin plugin, Map<String, Boolean> perm) {
        BukkitCompat.setPermissions(p, plugin, perm);
    }

    protected SuperPermissionHandler(Permissions plugin) {
        this.plugin = plugin;
        HashMap<String, Boolean> children = new HashMap<String, Boolean>();
        children.put("bPermissions.admin", true);
        Permission permission = new Permission("bPermissions.*", PermissionDefault.OP, children);
        if (plugin.getServer().getPluginManager().getPermission("bPermissions.*") == null) {
            plugin.getServer().getPluginManager().addPermission(permission);
        }
    }

    public void setupAllPlayers() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.setupPlayer(player);
        }
    }

    public void setupPlayer(Player player) {
        if (!this.plugin.isEnabled()) {
            return;
        }
        long time = System.currentTimeMillis();
        Map<String, Boolean> perms = ApiLayer.getEffectivePermissions(player.getWorld().getName(), CalculableType.USER, player.getName());
        SuperPermissionHandler.setPermissions((Permissible)player, (Plugin)this.plugin, perms);
        String prefix = ApiLayer.getValue(player.getWorld().getName(), CalculableType.USER, player.getName(), "prefix");
        String suffix = ApiLayer.getValue(player.getWorld().getName(), CalculableType.USER, player.getName(), "suffix");
        player.setMetadata("prefix", (MetadataValue)new FixedMetadataValue((Plugin)Permissions.instance, (Object)prefix));
        player.setMetadata("suffix", (MetadataValue)new FixedMetadataValue((Plugin)Permissions.instance, (Object)suffix));
        long finish = System.currentTimeMillis() - time;
        Debugger.log("Setup superperms for " + player.getName() + ". took " + finish + "ms.");
    }

    @EventHandler
    public void onAsyncPlayerPreLogin(AsyncPlayerPreLoginEvent event) {
        MainThread mt = MainThread.getInstance();
        if (!mt.getStarted()) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, "bPermissions not enabled");
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.setupPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            final Player player = event.getPlayer();
            final org.bukkit.World start = event.getFrom().getWorld();
            Runnable r = new Runnable(){

                public void run() {
                    if (!start.equals(player.getWorld())) {
                        SuperPermissionHandler.this.setupPlayer(player);
                    }
                }
            };
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, r, 5L);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPreLogin(AsyncPlayerPreLoginEvent event) {
        for (World world : this.wm.getAllWorlds()) {
            User user = world.getUser(event.getName());
            try {
                user.calculateEffectivePermissions();
                user.calculateEffectiveMeta();
            }
            catch (Exception e) {
                System.err.println(e.getStackTrace()[0].toString());
            }
            Debugger.log("PlayerPreLogin setup: " + user.getName());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerLoginEvent event) {
        this.setupPlayer(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.setupPlayer(player);
        if (player.hasPermission("*") && !player.isOp()) {
            player.sendMessage(ChatColor.BLUE + "[bPermissions] " + ChatColor.RED + "Tell the owner that the '*' permissions node doesn't work with bPermissions!");
        }
    }

    public void setupPlayer(String name) {
        if (Bukkit.getPlayer((String)name) != null) {
            Player player = Bukkit.getPlayer((String)name);
            this.setupPlayer(player);
        }
    }
}

