/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.Permissions;
import de.bananaco.bpermissions.imp.YamlWorld;
import java.io.File;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldLoader
implements Listener {
    private WorldManager wm = WorldManager.getInstance();
    private Map<String, String> mirrors;
    private Permissions permissions;

    protected WorldLoader(Permissions permissions, Map<String, String> mirrors) {
        this.mirrors = mirrors;
        this.permissions = permissions;
        for (World world : Bukkit.getServer().getWorlds()) {
            this.createWorld(world);
        }
    }

    @EventHandler
    public void onWorldInit(WorldInitEvent event) {
        this.createWorld(event.getWorld());
    }

    public void createWorld(World w) {
        String world = w.getName().toLowerCase();
        if (!this.mirrors.containsKey(world)) {
            Debugger.log("Loading world: " + w.getName());
            this.wm.createWorld(world, new YamlWorld(world, this.permissions, new File("plugins/bPermissions/" + world + "/")));
        }
    }
}

