/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp;

import de.bananaco.bpermissions.api.Calculable;
import de.bananaco.bpermissions.api.CalculableType;
import de.bananaco.bpermissions.api.Group;
import de.bananaco.bpermissions.api.MetaData;
import de.bananaco.bpermissions.api.Permission;
import de.bananaco.bpermissions.api.User;
import de.bananaco.bpermissions.api.World;
import de.bananaco.bpermissions.api.WorldManager;
import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.Permissions;
import de.bananaco.bpermissions.imp.YamlConfiguration;
import de.bananaco.bpermissions.imp.loadmanager.MainThread;
import de.bananaco.bpermissions.imp.loadmanager.TaskRunnable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class YamlWorld
extends World {
    protected static final String GROUPS = "groups";
    protected static final String PERMISSIONS = "permissions";
    protected static final String META = "meta";
    protected static final String USERS = "users";
    protected YamlConfiguration uconfig;
    protected YamlConfiguration gconfig;
    private final File ufile;
    private final File gfile;
    protected final Permissions permissions;
    protected final WorldManager wm = WorldManager.getInstance();
    protected boolean error = false;
    protected boolean save = false;

    public YamlWorld(String world, Permissions permissions, File root) {
        super(world);
        this.permissions = permissions;
        this.ufile = new File(root, "users.yml");
        this.gfile = new File(root, "groups.yml");
    }

    public String getDefaultGroup() {
        if (this.gconfig != null) {
            return this.gconfig.getString("default", "default");
        }
        return "default";
    }

    protected void cleanup() {
        super.cleanup();
        this.uconfig = new YamlConfiguration();
        this.gconfig = new YamlConfiguration();
        try {
            this.saveUnsafe();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean load() {
        if (MainThread.getInstance() == null) {
            Debugger.log("MainThread cancelled");
            return false;
        }
        try {
            MainThread.getInstance().schedule(new TaskRunnable(){

                public void run() {
                    try {
                        YamlWorld.this.clear();
                        YamlWorld.this.loadUnsafe();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public TaskRunnable.TaskType getType() {
                    return TaskRunnable.TaskType.LOAD;
                }
            });
            this.error = false;
        }
        catch (Exception e) {
            this.error = true;
            Bukkit.getServer().broadcastMessage(ChatColor.RED + "Permissions for world:" + this.getName() + " did not load correctly! Please consult server.log");
            e.printStackTrace();
        }
        return true;
    }

    protected synchronized void loadUnsafe() throws Exception {
        boolean autoSave = this.wm.getAutoSave();
        this.wm.setAutoSave(false);
        if (!this.ufile.exists()) {
            if (this.ufile.getParentFile() != null) {
                this.ufile.getParentFile().mkdirs();
            }
            this.ufile.createNewFile();
            this.gfile.createNewFile();
        }
        this.uconfig = new YamlConfiguration();
        this.gconfig = new YamlConfiguration();
        YamlConfiguration uconfig = this.uconfig;
        YamlConfiguration gconfig = this.gconfig;
        long t = System.currentTimeMillis();
        uconfig.load(this.ufile);
        gconfig.load(this.gfile);
        long f = System.currentTimeMillis();
        Debugger.log("Loading files took " + (f - t) + "ms");
        ConfigurationSection usersConfig = uconfig.getConfigurationSection(USERS);
        if (usersConfig != null) {
            Set names = usersConfig.getKeys(false);
            for (String name : names) {
                Set keys;
                List nPerm = usersConfig.getStringList(name + "." + PERMISSIONS);
                List nGroup = usersConfig.getStringList(name + "." + GROUPS);
                Set<Permission> perms = Permission.loadFromString(nPerm);
                User user = new User(name, nGroup, perms, this.getName(), this);
                ConfigurationSection meta = usersConfig.getConfigurationSection(name + "." + META);
                if (meta != null && (keys = meta.getKeys(false)) != null && keys.size() > 0) {
                    for (String key : keys) {
                        user.setValue(key, meta.get(key).toString());
                    }
                }
                this.add(user);
            }
        } else {
            Debugger.log("Empty ConfigurationSection:users:" + this.ufile.getPath());
        }
        ConfigurationSection groupsConfig = gconfig.getConfigurationSection(GROUPS);
        if (groupsConfig != null) {
            Set names = groupsConfig.getKeys(false);
            for (String name : names) {
                Set keys;
                List nPerm = groupsConfig.getStringList(name + "." + PERMISSIONS);
                List nGroup = groupsConfig.getStringList(name + "." + GROUPS);
                Set<Permission> perms = Permission.loadFromString(nPerm);
                Group group = new Group(name, nGroup, perms, this.getName(), this);
                ConfigurationSection meta = groupsConfig.getConfigurationSection(name + "." + META);
                if (meta != null && (keys = meta.getKeys(false)) != null && keys.size() > 0) {
                    for (String key : keys) {
                        group.setValue(key, meta.get(key).toString());
                    }
                }
                this.add(group);
            }
        } else {
            Debugger.log("Empty ConfigurationSection:groups:" + this.gfile.getPath());
        }
        Debugger.log(this.getAll(CalculableType.USER).size() + " users loaded.");
        Debugger.log(this.getAll(CalculableType.GROUP).size() + " groups loaded.");
        for (Player player : this.permissions.getServer().getOnlinePlayers()) {
            String name = player.getName();
            String world = player.getWorld().getName();
            if (this.wm.getWorld(world) != this) continue;
            this.getUser(name).calculateEffectivePermissions();
            this.getUser(name).calculateEffectiveMeta();
        }
        this.wm.setAutoSave(autoSave);
        if (this.wm.getAutoSave() && this.wm.getAutoSort()) {
            this.save();
        }
    }

    public boolean save() {
        if (MainThread.getInstance() == null) {
            Debugger.log("MainThread cancelled");
            return false;
        }
        if (this.error) {
            Bukkit.getServer().broadcastMessage(ChatColor.RED + "Permissions for world:" + this.getName() + " did not load correctly, please consult server.log.");
            return false;
        }
        this.save = true;
        try {
            MainThread.getInstance().schedule(new TaskRunnable(){

                public void run() {
                    try {
                        YamlWorld.this.saveUnsafe();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public TaskRunnable.TaskType getType() {
                    return TaskRunnable.TaskType.SAVE;
                }
            });
            this.save = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void saveUnsafe() throws Exception {
        if (!this.ufile.exists()) {
            this.ufile.getParentFile().mkdirs();
            this.ufile.createNewFile();
            this.gfile.createNewFile();
        }
        boolean sorting = this.wm.getAutoSort();
        String def = this.getDefaultGroup();
        if (sorting) {
            this.uconfig = new YamlConfiguration();
            this.gconfig = new YamlConfiguration();
        }
        YamlConfiguration uconfig = this.uconfig;
        YamlConfiguration gconfig = this.gconfig;
        gconfig.set("default", def);
        Set<Calculable> usr = this.getAll(CalculableType.USER);
        Debugger.log(usr.size() + " users saved.");
        ArrayList<Calculable> users = new ArrayList<Calculable>(usr);
        if (this.wm.getAutoSort()) {
            MetaData.sort(users, sorting);
        }
        for (Calculable user : users) {
            user.setSorting(sorting);
            String name = user.getName();
            uconfig.set("users." + name + "." + PERMISSIONS, user.serialisePermissions(sorting));
            uconfig.set("users." + name + "." + GROUPS, user.serialiseGroups(sorting));
            Map<String, String> map = user.getMeta();
            if (map.size() <= 0) continue;
            for (String key : map.keySet()) {
                uconfig.set("users." + name + "." + META + "." + key, map.get(key));
            }
        }
        Set<Calculable> grp = this.getAll(CalculableType.GROUP);
        Debugger.log(grp.size() + " groups saved.");
        ArrayList<Calculable> groups = new ArrayList<Calculable>(grp);
        if (sorting) {
            MetaData.sortGroups(groups);
        }
        for (Group group : groups) {
            group.setSorting(sorting);
            String name = sorting ? group.getName().toLowerCase() : group.getName();
            gconfig.set("groups." + name + "." + PERMISSIONS, group.serialisePermissions(sorting));
            gconfig.set("groups." + name + "." + GROUPS, group.serialiseGroups(sorting));
            Map<String, String> meta = group.getMeta();
            if (meta.size() <= 0) continue;
            for (String key : meta.keySet()) {
                gconfig.set("groups." + name + "." + META + "." + key, meta.get(key));
            }
        }
        long t = System.currentTimeMillis();
        uconfig.save(this.ufile);
        gconfig.save(this.gfile);
        long f = System.currentTimeMillis();
        Debugger.log("Saving files took " + (f - t) + "ms");
    }

    public boolean setupAll() {
        Player[] players;
        for (Player player : players = Bukkit.getOnlinePlayers()) {
            this.setupPlayer(player.getName());
        }
        return true;
    }

    public boolean isOnline(User user) {
        return Bukkit.getPlayer((String)user.getName()) != null;
    }

    public boolean setupPlayer(String player) {
        this.permissions.handler.setupPlayer(player);
        return true;
    }

    public void setDefaultGroup(String group) {
        this.gconfig.set("default", group);
        try {
            this.gconfig.save(this.gfile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

