/*
 * Decompiled with CFR 0.152.
 */
package de.bananaco.bpermissions.imp.loadmanager;

import de.bananaco.bpermissions.imp.Debugger;
import de.bananaco.bpermissions.imp.loadmanager.TaskRunnable;
import de.bananaco.bpermissions.imp.loadmanager.TaskThread;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainThread
extends Thread
implements TaskThread {
    private static MainThread thread = new MainThread();
    private List<Runnable> load = new ArrayList<Runnable>();
    private List<Runnable> save = new ArrayList<Runnable>();
    private List<Runnable> server = new ArrayList<Runnable>();
    private boolean running = true;
    private boolean started = false;

    public static MainThread getInstance() {
        return thread;
    }

    @Override
    public void run() {
        while (this.running) {
            this.check();
        }
    }

    private synchronized void check() {
        try {
            if (this.hasTasks()) {
                TaskRunnable run = null;
                List<Runnable> tasks = null;
                if (this.getTasks(TaskRunnable.TaskType.LOAD).size() > 0) {
                    tasks = this.getTasks(TaskRunnable.TaskType.LOAD);
                } else if (this.getTasks(TaskRunnable.TaskType.SAVE).size() > 0) {
                    tasks = this.getTasks(TaskRunnable.TaskType.SAVE);
                } else if (this.getTasks(TaskRunnable.TaskType.SERVER).size() > 0) {
                    tasks = this.getTasks(TaskRunnable.TaskType.SERVER);
                }
                if (tasks != null) {
                    run = (TaskRunnable)tasks.get(0);
                    tasks.remove(0);
                    final TaskRunnable r = run;
                    if (r.getType() == TaskRunnable.TaskType.SERVER || r.getType() == TaskRunnable.TaskType.SAVE) {
                        r.run();
                    } else {
                        new Thread(){

                            public void run() {
                                r.run();
                            }
                        }.start();
                    }
                }
            } else {
                MainThread.sleep(10L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Runnable> getTasks(TaskRunnable.TaskType type) {
        if (type == TaskRunnable.TaskType.LOAD) {
            return this.load;
        }
        if (type == TaskRunnable.TaskType.SAVE) {
            return this.save;
        }
        if (type == TaskRunnable.TaskType.SERVER) {
            return this.server;
        }
        return null;
    }

    @Override
    public boolean hasTasks() {
        return this.load.size() + this.save.size() + this.server.size() > 0;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void setRunning(boolean running) {
        this.load.clear();
        this.save.clear();
        this.server.clear();
        if (!running) {
            MainThread.thread.running = false;
            thread = null;
        }
    }

    public boolean getStarted() {
        return this.started;
    }

    public void setStarted(final boolean started) {
        TaskRunnable r = new TaskRunnable(){

            public void run() {
                thread.started = started;
                Debugger.log("Set started: " + started);
            }

            public TaskRunnable.TaskType getType() {
                return TaskRunnable.TaskType.SERVER;
            }
        };
        this.schedule(r);
    }

    @Override
    public void schedule(TaskRunnable r) {
        this.getTasks(r.getType()).add(r);
    }
}

