/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.bans;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.bans.Ban;
import com.sk89q.commandbook.bans.BanDatabase;
import com.sk89q.commandbook.util.PlayerUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CSVBanDatabase
implements BanDatabase {
    protected final Logger auditLogger = Logger.getLogger("Minecraft.CommandBook.Bans");
    protected final File storageFile;
    protected Map<String, Ban> nameBan = new HashMap<String, Ban>();
    protected Map<String, Ban> ipBan = new HashMap<String, Ban>();
    protected final Set<Ban> bans = new HashSet<Ban>();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    public CSVBanDatabase(File banStorageDir) {
        this.storageFile = new File(banStorageDir, "bans.csv");
        try {
            FileHandler handler = new FileHandler(new File(banStorageDir, "bans.%g.%u.log").getAbsolutePath().replace("\\", "/"), true);
            handler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return "[" + dateFormat.format(new Date()) + "] " + record.getMessage() + "\r\n";
                }
            });
            this.auditLogger.addHandler(handler);
        }
        catch (SecurityException e) {
            CommandBook.logger().warning("Failed to setup audit log for the CSV ban database: " + e.getMessage());
        }
        catch (IOException e) {
            CommandBook.logger().warning("Failed to setup audit log for the CSV ban database: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load() {
        FileInputStream input = null;
        boolean successful = true;
        try {
            String[] line;
            input = new FileInputStream(this.storageFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)input, "utf-8");
            CSVReader reader = new CSVReader(new BufferedReader(streamReader));
            while ((line = reader.readNext()) != null) {
                if (line.length < 5) {
                    CommandBook.logger().warning("A ban entry with < 5 fields was found!");
                    continue;
                }
                try {
                    String name = line[0].toLowerCase();
                    String address = line[1];
                    String reason = line[2];
                    long startDate = Long.parseLong(line[3]);
                    long endDate = Long.parseLong(line[4]);
                    if ("".equals(name) || "null".equals(name)) {
                        name = null;
                    }
                    if ("".equals(address) || "null".equals(address)) {
                        address = null;
                    }
                    Ban ban = new Ban(name, address, reason, startDate, endDate);
                    if (name != null) {
                        this.nameBan.put(name, ban);
                    }
                    if (address != null) {
                        this.ipBan.put(address, ban);
                    }
                    this.bans.add(ban);
                }
                catch (NumberFormatException e) {
                    CommandBook.logger().warning("Non-long long field found in ban!");
                }
            }
            CommandBook.logger().info(this.bans.size() + " banned name(s) loaded.");
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            this.nameBan = new HashMap<String, Ban>();
            this.ipBan = new HashMap<String, Ban>();
            CommandBook.logger().warning("Failed to load " + this.storageFile.getAbsolutePath() + ": " + e.getMessage());
            successful = false;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return successful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean save() {
        FileOutputStream output = null;
        boolean successful = true;
        try {
            output = new FileOutputStream(this.storageFile);
            CSVWriter writer = new CSVWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)output, "utf-8")));
            for (Ban ban : this.bans) {
                String[] line = new String[]{ban.getName(), ban.getAddress(), ban.getReason(), String.valueOf(ban.getStart()), String.valueOf(ban.getEnd())};
                writer.writeNext(line);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            CommandBook.logger().warning("Failed to save " + this.storageFile.getAbsolutePath() + ": " + e.getMessage());
            successful = false;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        return successful;
    }

    @Override
    public boolean unload() {
        for (Handler handler : this.auditLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            handler.flush();
            handler.close();
            this.auditLogger.removeHandler(handler);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBannedName(String name) {
        Ban ban = this.nameBan.get(name = name.toLowerCase());
        if (ban != null) {
            if (ban.getEnd() != 0L && ban.getEnd() - System.currentTimeMillis() <= 0L) {
                this.unban(name, null, null, "Tempban expired");
                this.save();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isBannedAddress(InetAddress address) {
        Ban ban = this.ipBan.get(address.getHostAddress());
        if (ban != null) {
            if (ban.getEnd() != 0L && ban.getEnd() - System.currentTimeMillis() <= 0L) {
                this.unban(null, address.getHostAddress(), null, "Tempban expired");
                this.save();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getBannedNameMesage(String name) {
        return this.getBannedNameMessage(name);
    }

    @Override
    public void ban(Player player, CommandSender source, String reason, long end) {
        this.ban(player.getName(), player.getAddress().getAddress().getHostAddress(), source, reason, end);
    }

    @Override
    public void ban(String name, String address, CommandSender source, String reason, long end) {
        Ban ban = new Ban(name, address, reason, System.currentTimeMillis(), end);
        String banned = null;
        String bannedName = null;
        if (name != null) {
            name = name.toLowerCase();
            this.nameBan.put(name, ban);
            banned = "name";
            bannedName = name;
        }
        if (address != null) {
            this.ipBan.put(address, ban);
            banned = banned == null ? "address" : banned + " and address";
            String string = bannedName = bannedName == null ? address : banned + "/" + address;
        }
        if (name != null || address != null) {
            this.bans.add(ban);
            this.auditLogger.info(String.format("BAN: %s (%s) banned %s '%s': %s", source == null ? "Plugin" : PlayerUtil.toUniqueName(source), source == null ? "local" : CommandBook.inst().toInetAddressString(source), banned, bannedName, reason));
        }
    }

    @Override
    public void banName(String name, CommandSender source, String reason) {
        this.ban(name, null, source, reason, 0L);
    }

    @Override
    public void banAddress(String address, CommandSender source, String reason) {
        this.ban(null, address, source, reason, 0L);
    }

    @Override
    public boolean unban(String name, String address, CommandSender source, String reason) {
        Ban ban = null;
        String banned = null;
        String bannedName = null;
        if (name != null && (ban = this.nameBan.remove(name = name.toLowerCase())) != null) {
            banned = "name";
            bannedName = name;
            if (this.ipBan.remove(ban.getAddress()) != null) {
                banned = banned + " and address";
                bannedName = bannedName + "/" + address;
            }
        }
        if (ban == null && address != null && (ban = this.ipBan.remove(address)) != null) {
            banned = "address";
            bannedName = address;
            if (this.nameBan.remove(ban.getName()) != null) {
                banned = "name and " + banned;
                bannedName = name + "/" + bannedName;
            }
        }
        if (ban != null) {
            this.bans.remove(ban);
            this.auditLogger.info(String.format("UNBAN: %s (%s) unbanned %s '%s': %s", source == null ? "Plugin" : PlayerUtil.toUniqueName(source), source == null ? "local" : CommandBook.inst().toInetAddressString(source), banned, bannedName, reason));
            return true;
        }
        return false;
    }

    @Override
    public boolean unbanName(String name, CommandSender source, String reason) {
        return this.unban(name, null, source, reason);
    }

    @Override
    public boolean unbanAddress(String address, CommandSender source, String reason) {
        return this.unban(null, address, source, reason);
    }

    @Override
    public String getBannedNameMessage(String name) {
        Ban ban = this.nameBan.get(name.toLowerCase());
        if (ban == null || ban.getReason() == null) {
            return "You are banned.";
        }
        return ban.getReason();
    }

    @Override
    public String getBannedAddressMessage(String address) {
        Ban ban = this.ipBan.get(address);
        if (ban == null || ban.getReason() == null) {
            return "You are banned by IP.";
        }
        return ban.getReason();
    }

    @Override
    public void logKick(Player player, CommandSender source, String reason) {
        this.auditLogger.info(String.format("KICKED: %s (%s) kicked player '%s': %s", PlayerUtil.toUniqueName(source), CommandBook.inst().toInetAddressString(source), player.getName(), reason));
    }

    @Override
    public void importFrom(BanDatabase bans) {
        for (Ban ban : bans) {
            if (ban.getName() != null && ban.getName().length() > 0) {
                this.nameBan.put(ban.getName(), ban);
            }
            if (ban.getAddress() != null && ban.getAddress().length() > 0) {
                this.ipBan.put(ban.getAddress(), ban);
            }
            this.bans.add(ban);
        }
    }

    @Override
    public Iterator<Ban> iterator() {
        return new Iterator<Ban>(){
            private final Iterator<Ban> setIter;
            private Ban next;
            {
                this.setIter = CSVBanDatabase.this.bans.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.setIter.hasNext();
            }

            @Override
            public Ban next() {
                this.next = this.setIter.next();
                return this.next;
            }

            @Override
            public void remove() {
                CSVBanDatabase.this.unban(this.next.getName(), this.next.getAddress(), null, "Removed by iterator");
            }
        };
    }

    @Override
    public Ban getBannedName(String name) {
        return this.nameBan.get(name);
    }

    @Override
    public Ban getBannedAddress(String address) {
        return this.ipBan.get(address);
    }
}

