/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.locations;

import com.sk89q.commandbook.CommandBook;
import com.sk89q.commandbook.CommandBookUtil;
import com.sk89q.commandbook.locations.TeleportSession;
import com.sk89q.commandbook.session.SessionComponent;
import com.sk89q.commandbook.session.SessionFactory;
import com.sk89q.commandbook.util.LegacyBukkitCompat;
import com.sk89q.commandbook.util.LocationUtil;
import com.sk89q.commandbook.util.PlayerUtil;
import com.sk89q.commandbook.util.TeleportPlayerIterator;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.zachsthings.libcomponents.ComponentInformation;
import com.zachsthings.libcomponents.Depend;
import com.zachsthings.libcomponents.InjectComponent;
import com.zachsthings.libcomponents.bukkit.BasePlugin;
import com.zachsthings.libcomponents.bukkit.BukkitComponent;
import com.zachsthings.libcomponents.config.ConfigurationBase;
import com.zachsthings.libcomponents.config.Setting;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

@ComponentInformation(friendlyName="Teleports", desc="Teleport-related commands")
@Depend(components={SessionComponent.class})
public class TeleportComponent
extends BukkitComponent
implements Listener {
    @InjectComponent
    private SessionComponent sessions;
    private LocalConfiguration config;

    @Override
    public void enable() {
        CommandBook.registerEvents(this);
        this.registerCommands(Commands.class);
        this.config = this.configure(new LocalConfiguration());
        this.sessions.registerSessionFactory(TeleportSession.class, new SessionFactory<TeleportSession>(){

            @Override
            public TeleportSession createSession(CommandSender user) {
                return new TeleportSession(TeleportComponent.this);
            }
        });
    }

    @Override
    public void reload() {
        this.configure(this.config);
    }

    public LocalConfiguration getConfig() {
        return this.config;
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        this.sessions.getSession(TeleportSession.class, (CommandSender)event.getPlayer()).rememberLocation(event.getPlayer());
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Location loc = event.getTo();
        Player player = event.getPlayer();
        if (event.isCancelled()) {
            return;
        }
        if (loc == this.sessions.getSession(TeleportSession.class, (CommandSender)player).getIgnoreLocation()) {
            this.sessions.getSession(TeleportSession.class, (CommandSender)player).setIgnoreLocation(null);
            return;
        }
        this.sessions.getSession(TeleportSession.class, (CommandSender)player).rememberLocation(event.getPlayer());
    }

    public class Commands {
        @Command(aliases={"teleport", "tp"}, usage="[target] <destination>", desc="Teleport to a location", flags="s", min=1, max=4)
        @CommandPermissions(value={"commandbook.teleport"})
        public void teleport(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets;
            Location loc;
            boolean[] relative = new boolean[]{false, false, false};
            if (args.argsLength() == 1) {
                loc = LocationUtil.matchLocation(sender, args.getString(0));
                if (loc.getX() == (double)loc.getBlockX()) {
                    loc.add(0.5, 0.0, 0.0);
                }
                if (loc.getZ() == (double)loc.getBlockZ()) {
                    loc.add(0.0, 0.0, 0.5);
                }
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
                CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport");
            } else if (args.argsLength() == 2) {
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
                loc = LocationUtil.matchLocation(sender, args.getString(1));
                if (loc.getX() == (double)loc.getBlockX()) {
                    loc.add(0.5, 0.0, 0.0);
                }
                if (loc.getZ() == (double)loc.getBlockZ()) {
                    loc.add(0.0, 0.0, 0.5);
                }
                CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport");
                for (Player target : targets) {
                    if (target == sender) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.teleport.other");
                    if (sender instanceof Player) {
                        CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport.other");
                    }
                    break;
                }
            } else if (args.argsLength() == 3) {
                targets = PlayerUtil.matchPlayers(PlayerUtil.checkPlayer(sender));
                int x = args.getInteger(1);
                int y = args.getInteger(2);
                int z = args.getInteger(3);
                loc = new Location(PlayerUtil.checkPlayer(sender).getWorld(), (double)x, (double)y, (double)z);
                if (loc.getX() == (double)loc.getBlockX()) {
                    loc.add(0.5, 0.0, 0.0);
                }
                if (loc.getZ() == (double)loc.getBlockZ()) {
                    loc.add(0.0, 0.0, 0.5);
                }
                CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport");
            } else if (args.argsLength() == 4) {
                World world;
                targets = PlayerUtil.matchPlayers(sender, args.getString(0));
                String xArg = args.getString(1);
                String yArg = args.getString(2);
                String zArg = args.getString(3);
                if (xArg.startsWith("~")) {
                    relative[0] = true;
                }
                if (yArg.startsWith("~")) {
                    relative[1] = true;
                }
                if (zArg.startsWith("~")) {
                    relative[2] = true;
                }
                if (relative[0] || relative[1] || relative[2]) {
                    CommandBook.inst().checkPermission(sender, "commandbook.locations.coords.relative");
                }
                int x = Integer.valueOf(xArg.replace("~", ""));
                int y = Integer.valueOf(yArg.replace("~", ""));
                int z = Integer.valueOf(zArg.replace("~", ""));
                try {
                    world = LegacyBukkitCompat.extractWorld(sender);
                }
                catch (Throwable t) {
                    world = sender instanceof Player ? ((Player)sender).getWorld() : (World)BasePlugin.server().getWorlds().get(0);
                }
                loc = new Location(world, (double)x, (double)y, (double)z);
                CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport");
                for (Player target : targets) {
                    if (target == sender) continue;
                    CommandBook.inst().checkPermission(sender, "commandbook.teleport.other");
                    if (sender instanceof Player) {
                        CommandBook.inst().checkPermission(sender, loc.getWorld(), "commandbook.teleport.other");
                    }
                    break;
                }
            } else {
                throw new CommandException("Invalid number of args.");
            }
            new TeleportPlayerIterator(sender, loc, args.hasFlag('s'), relative).iterate(targets);
        }

        @Command(aliases={"call"}, usage="<target>", desc="Request a teleport", min=1, max=1)
        @CommandPermissions(value={"commandbook.call"})
        public void requestTeleport(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            Player target = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
            CommandBook.inst().checkPermission(sender, target.getWorld(), "commandbook.call");
            TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)player).checkLastTeleportRequest(target);
            TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)target).addBringable(player);
            String senderMessage = CommandBookUtil.replaceColorMacros(CommandBookUtil.replaceMacros(sender, ((TeleportComponent)TeleportComponent.this).config.callMessageSender)).replaceAll("%ctarget%", PlayerUtil.toColoredName((CommandSender)target, null)).replaceAll("%target%", PlayerUtil.toName((CommandSender)target));
            String targetMessage = CommandBookUtil.replaceColorMacros(CommandBookUtil.replaceMacros(sender, ((TeleportComponent)TeleportComponent.this).config.callMessageTarget)).replaceAll("%ctarget%", PlayerUtil.toColoredName((CommandSender)target, null)).replaceAll("%target%", PlayerUtil.toName((CommandSender)target));
            sender.sendMessage(senderMessage);
            target.sendMessage(targetMessage);
        }

        @Command(aliases={"bring", "tphere", "summon", "s"}, usage="<target>", desc="Bring a player to you", min=1, max=1)
        public void bring(CommandContext args, CommandSender sender) throws CommandException {
            Player player = PlayerUtil.checkPlayer(sender);
            if (!CommandBook.inst().hasPermission(sender, "commandbook.teleport.other")) {
                Player target = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                if (!TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)player).isBringable(target)) {
                    throw new CommandException(((TeleportComponent)TeleportComponent.this).config.bringMessageNoPerm);
                }
                String senderMessage = CommandBookUtil.replaceColorMacros(CommandBookUtil.replaceMacros(sender, ((TeleportComponent)TeleportComponent.this).config.bringMessageSender)).replaceAll("%ctarget%", PlayerUtil.toColoredName((CommandSender)target, null)).replaceAll("%target%", target.getName());
                String targetMessage = CommandBookUtil.replaceColorMacros(CommandBookUtil.replaceMacros(sender, ((TeleportComponent)TeleportComponent.this).config.bringMessageTarget)).replaceAll("%ctarget%", PlayerUtil.toColoredName((CommandSender)target, null)).replaceAll("%target%", target.getName());
                sender.sendMessage(senderMessage);
                target.sendMessage(targetMessage);
                target.teleport((Entity)player);
                return;
            }
            Iterable<Player> targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            Location loc = player.getLocation();
            new TeleportPlayerIterator(sender, loc){

                @Override
                public void perform(Player player) {
                    if (this.sender instanceof Player && !player.getWorld().getName().equals(((Player)this.sender).getWorld().getName()) && !CommandBook.inst().hasPermission(this.sender, player.getWorld(), "commandbook.teleport.other")) {
                        return;
                    }
                    this.oldLoc = player.getLocation();
                    player.teleport(this.loc);
                }
            }.iterate(targets);
        }

        @Command(aliases={"put", "place"}, usage="<target>", desc="Put a player at where you are looking", min=1, max=1)
        @CommandPermissions(value={"commandbook.teleport.other"})
        public void put(CommandContext args, CommandSender sender) throws CommandException {
            Iterable<Player> targets = PlayerUtil.matchPlayers(sender, args.getString(0));
            Location loc = LocationUtil.matchLocation(sender, "#target");
            new TeleportPlayerIterator(sender, loc){

                @Override
                public void perform(Player player) {
                    this.oldLoc = player.getLocation();
                    Location playerLoc = player.getLocation();
                    this.loc.setPitch(playerLoc.getPitch());
                    this.loc.setYaw(playerLoc.getYaw());
                    player.teleport(this.loc);
                }
            }.iterate(targets);
        }

        @Command(aliases={"return", "ret"}, usage="[player]", desc="Teleport back to your last location", min=0, max=1)
        @CommandPermissions(value={"commandbook.return"})
        public void ret(CommandContext args, CommandSender sender) throws CommandException {
            Location lastLoc;
            Player player;
            if (args.argsLength() > 0) {
                player = PlayerUtil.matchSinglePlayer(sender, args.getString(0));
                if (player != sender) {
                    CommandBook.inst().checkPermission(sender, "commandbook.return.other");
                }
            } else {
                player = PlayerUtil.checkPlayer(sender);
            }
            if ((lastLoc = TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)player).popLastLocation()) != null) {
                TeleportComponent.this.sessions.getSession(TeleportSession.class, (CommandSender)player).setIgnoreLocation(lastLoc);
                lastLoc.getChunk().load(true);
                player.teleport(lastLoc);
                sender.sendMessage(ChatColor.YELLOW + "You've been returned.");
            } else {
                sender.sendMessage(ChatColor.RED + "There's no past location in your history.");
            }
        }
    }

    public static class LocalConfiguration
    extends ConfigurationBase {
        @Setting(value="call-message.sender")
        public String callMessageSender = "`yTeleport request sent.";
        @Setting(value="call-message.target")
        public String callMessageTarget = "`c**TELEPORT** %cname%`c requests a teleport! Use /bring <name> to accept.";
        @Setting(value="call-message.too-soon")
        public String callMessageTooSoon = "Wait a bit before asking again.";
        @Setting(value="bring-message.sender")
        public String bringMessageSender = "`yPlayer teleported.";
        @Setting(value="bring-message.target")
        public String bringMessageTarget = "`yYour teleport request to %cname%`y was accepted.";
        @Setting(value="bring-message.no-perm")
        public String bringMessageNoPerm = "That person didn't request a teleport (recently) and you don't have permission to teleport anyone.";
    }
}

