/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.commandbook.locations;

import com.sk89q.commandbook.locations.TeleportComponent;
import com.sk89q.commandbook.session.PersistentSession;
import com.sk89q.minecraft.util.commands.CommandException;
import com.zachsthings.libcomponents.config.Setting;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TeleportSession
extends PersistentSession {
    private static final long MAX_AGE = TimeUnit.DAYS.toMillis(10L);
    private static final long BRINGABLE_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final long TP_REQUEST_WAIT_TIME = TimeUnit.SECONDS.toMillis(30L);
    private static final long RECONNECT_GRACE = TimeUnit.MINUTES.toMillis(1L);
    private static final int LOCATION_HISTORY_SIZE = 10;
    private final TeleportComponent component;
    @Setting(value="teleport.bringable")
    private Map<String, Long> bringable = new HashMap<String, Long>();
    @Setting(value="teleport.requests")
    private final Map<String, Long> teleportRequests = new HashMap<String, Long>();
    private final LinkedList<Location> locationHistory = new LinkedList();
    private Location ignoreTeleportLocation;

    public TeleportSession(TeleportComponent component) {
        super(MAX_AGE);
        this.component = component;
    }

    @Override
    public void handleReconnect(CommandSender player) {
        if (this.getGoneTime() >= RECONNECT_GRACE) {
            this.bringable = new HashMap<String, Long>();
        }
    }

    public void addBringable(Player player) {
        this.bringable.put(player.getName(), System.currentTimeMillis());
    }

    public void removeBringable(Player player) {
        this.bringable.put(player.getName(), System.currentTimeMillis());
    }

    public boolean isBringable(Player player) {
        long now = System.currentTimeMillis();
        Long time = this.bringable.remove(player.getName());
        return time != null && now - time < BRINGABLE_TIME;
    }

    public void checkLastTeleportRequest(Player target) throws CommandException {
        long now = System.currentTimeMillis();
        Long time = this.teleportRequests.remove(target.getName());
        if (time != null && now - time < TP_REQUEST_WAIT_TIME) {
            throw new CommandException(this.component.getConfig().callMessageTooSoon);
        }
        this.teleportRequests.put(target.getName(), now);
    }

    public void rememberLocation(Location location) {
        if (this.locationHistory.size() > 0 && this.locationHistory.peek().equals((Object)location)) {
            return;
        }
        this.locationHistory.add(0, location);
        while (this.locationHistory.size() > 10) {
            this.locationHistory.poll();
        }
    }

    public void rememberLocation(Player player) {
        this.rememberLocation(player.getLocation());
    }

    public Location popLastLocation() {
        return this.locationHistory.poll();
    }

    public void setIgnoreLocation(Location loc) {
        this.ignoreTeleportLocation = loc;
    }

    public Location getIgnoreLocation() {
        return this.ignoreTeleportLocation;
    }
}

