/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jinglenote;

import com.sk89q.jinglenote.JingleNotePlayer;
import com.sk89q.jinglenote.JingleSequencer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;

public class MidiJingleSequencer
implements JingleSequencer {
    private static final int[] instruments = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 3};
    protected final File midiFile;
    private Sequencer sequencer = null;

    public MidiJingleSequencer(File midiFile) throws MidiUnavailableException, InvalidMidiDataException, IOException {
        this.midiFile = midiFile;
        try {
            this.sequencer = MidiSystem.getSequencer(false);
            this.sequencer.open();
            Sequence seq = MidiSystem.getSequence(midiFile);
            this.sequencer.setSequence(seq);
        }
        catch (MidiUnavailableException e) {
            this.sequencer.close();
            throw e;
        }
        catch (InvalidMidiDataException e) {
            this.sequencer.close();
            throw e;
        }
        catch (IOException e) {
            this.sequencer.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(final JingleNotePlayer notePlayer) throws InterruptedException {
        final HashMap patches = new HashMap();
        try {
            this.sequencer.getTransmitter().setReceiver(new Receiver(){

                @Override
                public void send(MidiMessage message, long timeStamp) {
                    if ((message.getStatus() & 0xF0) == 192) {
                        ShortMessage msg = (ShortMessage)message;
                        int chan = msg.getChannel();
                        int patch = msg.getData1();
                        patches.put(chan, patch);
                    } else if ((message.getStatus() & 0xF0) == 144) {
                        ShortMessage msg = (ShortMessage)message;
                        int chan = msg.getChannel();
                        int n = msg.getData1();
                        if (chan != 9) {
                            notePlayer.play(MidiJingleSequencer.toMCInstrument((Integer)patches.get(chan)), MidiJingleSequencer.toMCNote(n));
                        }
                    }
                }

                @Override
                public void close() {
                }
            });
            this.sequencer.start();
            while (this.sequencer.isRunning() && notePlayer.isActive()) {
                Thread.sleep(1000L);
            }
            this.sequencer.stop();
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        finally {
            this.sequencer.close();
        }
    }

    @Override
    public void stop() {
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }

    private static byte toMCNote(int n) {
        if (n < 54) {
            return (byte)((n - 6) % 12);
        }
        if (n > 78) {
            return (byte)((n - 6) % 12 + 12);
        }
        return (byte)(n - 54);
    }

    private static byte toMCInstrument(Integer patch) {
        if (patch == null) {
            return 0;
        }
        if (patch < 0 || patch >= instruments.length) {
            return 0;
        }
        return (byte)instruments[patch];
    }
}

