/*
 * Decompiled with CFR 0.152.
 */
package to.joe.decapitation;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import to.joe.decapitation.command.BountyCommand;
import to.joe.decapitation.command.ClearNameCommand;
import to.joe.decapitation.command.SetNameCommand;
import to.joe.decapitation.command.SpawnHeadCommand;
import to.joe.decapitation.datastorage.DataStorageException;
import to.joe.decapitation.datastorage.DataStorageInterface;
import to.joe.decapitation.datastorage.MySQLDataStorageImplementation;
import to.joe.decapitation.datastorage.YamlDataStorageImplementation;

public class Decapitation
extends JavaPlugin
implements Listener {
    double allDeaths;
    double killedByPlayer;
    public boolean bounties = false;
    private boolean huntedDropOnly;
    private boolean placeInKillerInv;
    public boolean canClaimOwn;
    private double tax;
    public double minimumBounty;
    private DataStorageInterface dsi;
    public static Economy economy = null;

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            economy = (Economy)economyProvider.getProvider();
        }
        return economy != null;
    }

    public DataStorageInterface getDsi() {
        return this.dsi;
    }

    public double getTax() {
        return this.tax;
    }

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.allDeaths = this.getConfig().getDouble("dropSkulls.allDeaths", 0.0);
        this.killedByPlayer = this.getConfig().getDouble("dropSkulls.killedByPlayer", 1.0);
        this.placeInKillerInv = this.getConfig().getBoolean("dropSkulls.placeInKillerInv", false);
        this.tax = this.getConfig().getDouble("bounty.tax", 0.05);
        this.minimumBounty = this.getConfig().getDouble("bounty.minimum", 10.0);
        this.huntedDropOnly = this.getConfig().getBoolean("bounty.huntedDropOnly", false);
        this.canClaimOwn = this.getConfig().getBoolean("bounty.canClaimOwn", true);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("setname").setExecutor((CommandExecutor)new SetNameCommand());
        this.getCommand("clearname").setExecutor((CommandExecutor)new ClearNameCommand());
        this.getCommand("spawnhead").setExecutor((CommandExecutor)new SpawnHeadCommand(this));
        this.getCommand("bounty").setExecutor((CommandExecutor)new BountyCommand(this));
        if (this.getConfig().getBoolean("bounty.enabled")) {
            this.bounties = this.setupEconomy();
            if (this.bounties) {
                this.getLogger().info("Econ detected");
            } else {
                this.getLogger().info("Econ not detected");
            }
        }
        if (this.bounties) {
            if (this.getConfig().getString("datastorage").equalsIgnoreCase("mysql")) {
                try {
                    this.dsi = new MySQLDataStorageImplementation(this, this.getConfig().getString("database.url"), this.getConfig().getString("database.username"), this.getConfig().getString("database.password"));
                }
                catch (SQLException e) {
                    this.getLogger().log(Level.SEVERE, "Error connecting to mysql database", e);
                    this.bounties = false;
                }
            } else if (this.getConfig().getString("datastorage").equalsIgnoreCase("yaml")) {
                try {
                    this.dsi = new YamlDataStorageImplementation(this);
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "Error setting up yaml storage", e);
                    this.bounties = false;
                }
            }
        }
        if (this.bounties) {
            this.getLogger().info("Bounties enabled");
        } else {
            this.getLogger().info("Bounties not enabled");
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player p = event.getEntity();
        Player k = p.getKiller();
        try {
            if (this.bounties && this.huntedDropOnly && this.dsi.getBounty(p.getName()) == null) {
                return;
            }
        }
        catch (DataStorageException e) {
            this.getLogger().log(Level.SEVERE, "Error getting if player has bounty", e);
        }
        if (p.hasPermission("decapitation.dropheads") && (this.allDeaths > Math.random() || this.killedByPlayer > Math.random() && k != null) && (k == null || k != null && k.hasPermission("decapitation.collectheads"))) {
            ItemStack i = new ItemStack(Material.SKULL_ITEM, 1, 3);
            SkullMeta meta = (SkullMeta)i.getItemMeta();
            meta.setOwner(event.getEntity().getName());
            i.setItemMeta((ItemMeta)meta);
            if (this.placeInKillerInv && k != null) {
                if (!k.getInventory().addItem(new ItemStack[]{i}).isEmpty()) {
                    k.getWorld().dropItem(k.getLocation(), i);
                }
            } else {
                event.getDrops().add(i);
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.bounties) {
            int unclaimedHeads = 0;
            try {
                unclaimedHeads = this.dsi.getNumUnclaimedHeads(event.getPlayer().getName());
            }
            catch (DataStorageException e) {
                this.getLogger().log(Level.SEVERE, "Error getting number of unclaimed heads", e);
            }
            if (unclaimedHeads > 0) {
                if (unclaimedHeads == 1) {
                    event.getPlayer().sendMessage(ChatColor.GOLD + "You have " + unclaimedHeads + " unclaimed head.");
                } else {
                    event.getPlayer().sendMessage(ChatColor.GOLD + "You have " + unclaimedHeads + " unclaimed heads.");
                }
                event.getPlayer().sendMessage(ChatColor.GOLD + "Type /bounty redeem to receive them");
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getPlayer().hasPermission("decapitation.info") && event.getClickedBlock().getType() == Material.SKULL) {
            Skull s = (Skull)event.getClickedBlock().getState();
            if (s.hasOwner()) {
                event.getPlayer().sendMessage(ChatColor.GREEN + "The head of " + s.getOwner());
            } else {
                event.getPlayer().sendMessage(ChatColor.GREEN + "That head has no name attached");
            }
        }
    }
}

