/*
 * Decompiled with CFR 0.152.
 */
package to.joe.decapitation.datastorage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import to.joe.decapitation.Bounty;
import to.joe.decapitation.Decapitation;
import to.joe.decapitation.datastorage.DataStorageException;
import to.joe.decapitation.datastorage.DataStorageInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDataStorageImplementation
implements DataStorageInterface {
    private Decapitation plugin;
    private File configFile;
    private YamlConfiguration config;
    private int lastId;

    public YamlDataStorageImplementation(Decapitation plugin) throws IOException {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "bounties.yml");
        if (!this.configFile.exists() || this.configFile.isDirectory()) {
            this.configFile.createNewFile();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        if (!this.config.isConfigurationSection("bounties")) {
            this.config.createSection("bounties");
        }
        this.lastId = 0;
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        for (String key : keys) {
            try {
                int value = Integer.valueOf(key);
                if (value < 0) {
                    this.plugin.getLogger().warning("Picked up an invalid id at bounties." + key);
                    continue;
                }
                if (value <= this.lastId) continue;
                this.lastId = value;
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
    }

    private void saveConfig() throws DataStorageException {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            throw new DataStorageException(e);
        }
    }

    @Override
    public int getNumBounties() throws DataStorageException {
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        int bounties = 0;
        for (String key : keys) {
            try {
                Integer.valueOf(key);
                ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(key);
                if (section.getString("hunter") != null) continue;
                ++bounties;
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
        return bounties;
    }

    @Override
    public int getNumUnclaimedHeads(String issuer) throws DataStorageException {
        int count = 0;
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        for (String key : keys) {
            try {
                Integer.valueOf(key);
                ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(key);
                if (!issuer.equalsIgnoreCase(section.getString("issuer")) || section.getLong("turnedin") == 0L || section.getLong("redeemed") != 0L) continue;
                ++count;
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
        return count;
    }

    @Override
    public List<Bounty> getUnclaimedBounties(String issuer) throws DataStorageException {
        ArrayList<Bounty> bounties = new ArrayList<Bounty>();
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        for (String key : keys) {
            try {
                int keyValue = Integer.valueOf(key);
                ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(key);
                if (!issuer.equalsIgnoreCase(section.getString("issuer")) || section.getLong("turnedin") == 0L || section.getLong("reedemed") != 0L) continue;
                bounties.add(Bounty.fromConfigurationSection(keyValue, section));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
        return bounties;
    }

    @Override
    public List<Bounty> getBounties(int min, int max) throws DataStorageException {
        ArrayList<Bounty> bounties = new ArrayList<Bounty>();
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        ArrayList<Bounty> allBounties = new ArrayList<Bounty>();
        for (String key : keys) {
            try {
                int keyValue = Integer.valueOf(key);
                ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(key);
                if (section.getString("hunter") != null) continue;
                allBounties.add(Bounty.fromConfigurationSection(keyValue, section));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
        Collections.sort(allBounties, Collections.reverseOrder(new Bounty.BountyRewardComparator()));
        if (allBounties.size() - 1 < max) {
            max = allBounties.size() - 1;
        }
        if (min > allBounties.size()) {
            return bounties;
        }
        for (int i = min; i <= max; ++i) {
            bounties.add((Bounty)allBounties.get(i));
        }
        return bounties;
    }

    @Override
    public List<Bounty> getBounties(String hunted) throws DataStorageException {
        ArrayList<Bounty> bounties = new ArrayList<Bounty>();
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        for (String key : keys) {
            try {
                int keyValue = Integer.valueOf(key);
                ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(key);
                if (section.getString("hunted") == null || !section.getString("hunted").matches(".*" + hunted + ".*") || section.getString("hunter") != null) continue;
                bounties.add(Bounty.fromConfigurationSection(keyValue, section));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
        Collections.sort(bounties, new Bounty.BountyRewardComparator());
        return bounties;
    }

    @Override
    public List<Bounty> getOwnBounties(String issuer) throws DataStorageException {
        ArrayList<Bounty> bounties = new ArrayList<Bounty>();
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        for (String key : keys) {
            try {
                int keyValue = Integer.valueOf(key);
                ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(key);
                if (!issuer.equalsIgnoreCase(section.getString("issuer")) || section.getString("hunter") != null) continue;
                bounties.add(Bounty.fromConfigurationSection(keyValue, section));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
        return bounties;
    }

    @Override
    public Bounty getBounty(String hunted) throws DataStorageException {
        ArrayList<Bounty> bounties = new ArrayList<Bounty>();
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        for (String key : keys) {
            try {
                int keyValue = Integer.valueOf(key);
                ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(key);
                if (!hunted.equalsIgnoreCase(section.getString("hunted")) || section.getString("hunter") != null) continue;
                bounties.add(Bounty.fromConfigurationSection(keyValue, section));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
        Collections.sort(bounties, Collections.reverseOrder(new Bounty.BountyRewardComparator()));
        return bounties.size() == 0 ? null : (Bounty)bounties.get(0);
    }

    @Override
    public Bounty getBounty(String hunted, String issuer) throws DataStorageException {
        ArrayList<Bounty> bounties = new ArrayList<Bounty>();
        Set keys = this.config.getConfigurationSection("bounties").getKeys(false);
        for (String key : keys) {
            try {
                int keyValue = Integer.valueOf(key);
                ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(key);
                if (!hunted.equalsIgnoreCase(section.getString("hunted")) || !issuer.equalsIgnoreCase(section.getString("issuer")) || section.getString("hunter") != null) continue;
                bounties.add(Bounty.fromConfigurationSection(keyValue, section));
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().warning("Picked up an invalid key at bounties." + key);
            }
        }
        Collections.sort(bounties, Collections.reverseOrder(new Bounty.BountyRewardComparator()));
        return bounties.size() == 0 ? null : (Bounty)bounties.get(0);
    }

    @Override
    public Bounty addBounty(Bounty bounty) throws DataStorageException {
        int newId = this.lastId + 1;
        this.config.getConfigurationSection("bounties").createSection(Integer.toString(newId));
        ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(Integer.toString(newId));
        section.set("issuer", (Object)bounty.getIssuer());
        section.set("hunted", (Object)bounty.getHunted());
        section.set("reward", (Object)bounty.getReward());
        this.lastId = newId;
        this.saveConfig();
        return new Bounty(newId, bounty.getIssuer(), bounty.getHunted(), bounty.getReward(), null, null, null, null);
    }

    @Override
    public void updateBounty(Bounty bounty) throws DataStorageException {
        if (this.config.getConfigurationSection("bounties").getConfigurationSection(Integer.toString(bounty.getID())) == null) {
            throw new DataStorageException("Tried to update a bounty whose id didn't exist!");
        }
        ConfigurationSection section = this.config.getConfigurationSection("bounties").getConfigurationSection(Integer.toString(bounty.getID()));
        section.set("issuer", (Object)bounty.getIssuer());
        section.set("hunted", (Object)bounty.getHunted());
        section.set("reward", (Object)bounty.getReward());
        section.set("created", (Object)bounty.getCreated().getTime());
        section.set("hunter", (Object)bounty.getHunter());
        section.set("turnedin", (Object)bounty.getTurnedIn().getTime());
        section.set("redeemed", (Object)bounty.getRedeemed().getTime());
        this.saveConfig();
    }

    @Override
    public void deleteBounty(Bounty bounty) throws DataStorageException {
        if (this.config.getConfigurationSection("bounties").getConfigurationSection(Integer.toString(bounty.getID())) == null) {
            throw new DataStorageException("Tried to delete a bounty whose id didn't exist!");
        }
        this.config.set("bounties." + Integer.toString(bounty.getID()), null);
        if (bounty.getID() == this.lastId) {
            --this.lastId;
        }
        this.saveConfig();
    }
}

