/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.database.Account;

public class API {
    private final Fe plugin;

    public API(Fe plugin) {
        this.plugin = plugin;
    }

    public List<Account> getTopAccounts() {
        return this.plugin.getFeDatabase().getTopAccounts();
    }

    public List<Account> getAccounts() {
        return this.plugin.getFeDatabase().getAccounts();
    }

    public double getDefaultHoldings() {
        return this.plugin.getConfig().getDouble("holdings");
    }

    public double getMaxHoldings() {
        return this.plugin.getConfig().getDouble("maxholdings");
    }

    public String getCurrencyPrefix() {
        return this.plugin.getConfig().getString("currency.prefix");
    }

    public boolean isCurrencyNegative() {
        return this.plugin.getConfig().getBoolean("currency.negative");
    }

    public String getCurrencyMajorSingle() {
        return this.plugin.getConfig().getString("currency.major.single");
    }

    public String getCurrencyMajorMultiple() {
        return this.plugin.getConfig().getString("currency.major.multiple");
    }

    public boolean isMinorCurrencyEnabled() {
        return this.plugin.getConfig().getBoolean("currency.minor.enabled");
    }

    public String getCurrencyMinorSingle() {
        return this.plugin.getConfig().getString("currency.minor.single");
    }

    public String getCurrencyMinorMultiple() {
        return this.plugin.getConfig().getString("currency.minor.multiple");
    }

    public Account createAccount(String name) {
        return this.plugin.getFeDatabase().createAccount(name.toLowerCase());
    }

    public void removeAccount(String name) {
        this.plugin.getFeDatabase().removeAccount(name.toLowerCase());
    }

    public Account getAccount(String name) {
        return this.plugin.getFeDatabase().getAccount(name.toLowerCase());
    }

    public boolean accountExists(String name) {
        return this.plugin.getFeDatabase().accountExists(name.toLowerCase());
    }

    public String formatNoColor(double amount) {
        return ChatColor.stripColor((String)this.format(amount));
    }

    private String formatValue(double value) {
        boolean isWholeNumber = value == (double)Math.round(value);
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        formatSymbols.setDecimalSeparator('.');
        String pattern = isWholeNumber ? "###,###.###" : "###,##0.00";
        DecimalFormat df = new DecimalFormat(pattern, formatSymbols);
        return df.format(value);
    }

    public String format(double amount) {
        amount = this.getMoneyRounded(amount);
        String suffix = " ";
        if (this.isMinorCurrencyEnabled() && amount < 1.0) {
            if (amount == 0.01) {
                suffix = suffix + this.getCurrencyMinorSingle();
            } else if (amount < 1.0) {
                suffix = suffix + this.getCurrencyMinorMultiple();
            }
            amount *= 100.0;
        } else {
            suffix = amount == 1.0 ? suffix + this.getCurrencyMajorSingle() : suffix + this.getCurrencyMajorMultiple();
        }
        if (suffix.equalsIgnoreCase(" ")) {
            suffix = "";
        }
        return Phrase.SECONDARY_COLOR.parse(new String[0]) + this.getCurrencyPrefix() + Phrase.PRIMARY_COLOR.parse(new String[0]) + this.formatValue(amount) + Phrase.SECONDARY_COLOR.parse(new String[0]) + suffix;
    }

    public double getMoneyRounded(double amount) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        String formattedAmount = twoDForm.format(amount);
        formattedAmount = formattedAmount.replace(",", ".");
        return Double.valueOf(formattedAmount);
    }

    public String formatNoColor(Account account) {
        return ChatColor.stripColor((String)this.format(account));
    }

    public String format(Account account) {
        return this.format(account.getMoney());
    }

    public void clean() {
        this.plugin.getFeDatabase().clean();
    }
}

