/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe;

import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.melonbrew.fe.API;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.database.Account;

public class Economy_Fe
implements Economy {
    private final String name = "Fe";
    private Plugin plugin = null;
    private Fe fe = null;
    private API api = null;

    public Economy_Fe(Plugin plugin) {
        Plugin efe;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.fe == null && (efe = plugin.getServer().getPluginManager().getPlugin("Fe")) != null && efe.isEnabled()) {
            this.fe = (Fe)efe;
            this.api = this.fe.getAPI();
            this.fe.log("Vault support enabled.");
        }
    }

    public boolean isEnabled() {
        if (this.api == null) {
            return false;
        }
        return this.fe.isEnabled();
    }

    public String getName() {
        return "Fe";
    }

    public String format(double amount) {
        return this.api.formatNoColor(amount);
    }

    public String currencyNameSingular() {
        return this.api.getCurrencyMajorSingle();
    }

    public String currencyNamePlural() {
        return this.api.getCurrencyMajorMultiple();
    }

    public double getBalance(String playerName) {
        if (this.api.accountExists(playerName)) {
            return this.api.getAccount(playerName).getMoney();
        }
        return 0.0;
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (!this.api.accountExists(playerName)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account doesn't exist");
        }
        Account account = this.api.getAccount(playerName);
        if (account.has(amount)) {
            account.withdraw(amount);
            return new EconomyResponse(amount, account.getMoney(), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, account.getMoney(), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        if (!this.api.accountExists(playerName)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account doesn't exist");
        }
        Account account = this.api.getAccount(playerName);
        account.deposit(amount);
        return new EconomyResponse(amount, account.getMoney(), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Fe does not support bank accounts!");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Fe does not support bank accounts!");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Fe does not support bank accounts!");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Fe does not support bank accounts!");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Fe does not support bank accounts!");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Fe does not support bank accounts!");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Fe does not support bank accounts!");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Fe does not support bank accounts!");
    }

    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    public boolean hasBankSupport() {
        return false;
    }

    public boolean hasAccount(String playerName) {
        return this.api.accountExists(playerName);
    }

    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        this.api.createAccount(playerName);
        return true;
    }

    public int fractionalDigits() {
        return -1;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_Fe economy = null;

        public EconomyServerListener(Economy_Fe economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin efe;
            if (Economy_Fe.this.fe == null && (efe = Economy_Fe.this.plugin.getServer().getPluginManager().getPlugin("Fe")) != null && efe.isEnabled()) {
                Economy_Fe.this.fe = (Fe)efe;
                Economy_Fe.this.api = Economy_Fe.this.fe.getAPI();
                Economy_Fe.this.fe.log("Vault support enabled.");
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (Economy_Fe.this.fe != null && event.getPlugin().getDescription().getName().equals("Fe")) {
                Economy_Fe.this.fe = null;
                Economy_Fe.this.api = null;
                Bukkit.getLogger().info("[Fe] Vault support disabled.");
            }
        }
    }
}

