/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.melonbrew.fe.API;
import org.melonbrew.fe.Economy_Fe;
import org.melonbrew.fe.FeCommand;
import org.melonbrew.fe.Metrics;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.UpdateCheck;
import org.melonbrew.fe.database.Account;
import org.melonbrew.fe.database.Database;
import org.melonbrew.fe.database.databases.MySQLDB;
import org.melonbrew.fe.database.databases.SQLiteDB;
import org.melonbrew.fe.listeners.FePlayerListener;

public class Fe
extends JavaPlugin {
    private Logger log;
    private API api;
    private Database database;
    private Set<Database> databases;
    private double currentVersion;
    private double latestVersion;
    private String latestVersionString;

    public void onEnable() {
        this.log = this.getServer().getLogger();
        this.getDataFolder().mkdirs();
        new FePlayerListener(this);
        Phrase.init(this);
        this.databases = new HashSet<Database>();
        this.databases.add(new MySQLDB(this));
        this.databases.add(new SQLiteDB(this));
        this.getConfig().options().copyDefaults(true);
        for (Database database : this.databases) {
            String name = database.getConfigName();
            ConfigurationSection section = this.getConfig().getConfigurationSection(name);
            if (section == null) {
                section = this.getConfig().createSection(name);
            }
            database.getConfigDefaults(section);
            if (!section.getKeys(false).isEmpty()) continue;
            this.getConfig().set(name, null);
        }
        this.getConfig().options().header("Fe Config - meloncraft.com\nholdings - The amount of money that players will start out with\nprefix - The message prefix\ncurrency - The single and multiple names for the currency\ntype - The type of database used (sqlite or mysql)\n");
        this.saveConfig();
        this.api = new API(this);
        if (!this.setupDatabase()) {
            return;
        }
        this.setupVault();
        String currentVersionString = this.getDescription().getVersion();
        this.currentVersion = this.versionToDouble(currentVersionString);
        this.setLatestVersion(this.currentVersion);
        this.setLatestVersionString(currentVersionString);
        this.getCommand("fe").setExecutor((CommandExecutor)new FeCommand(this));
        if (this.getConfig().getBoolean("updatecheck")) {
            this.getServer().getScheduler().runTaskAsynchronously((Plugin)this, (Runnable)new UpdateCheck(this));
        }
        this.loadMetrics();
    }

    public double versionToDouble(String version) {
        boolean isSnapshot = version.endsWith("-SNAPSHOT");
        version = version.replace("-SNAPSHOT", "");
        String fixed = "";
        boolean doneFirst = false;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (doneFirst) continue;
                doneFirst = true;
            }
            fixed = fixed + c;
        }
        try {
            double ret = Double.parseDouble(fixed);
            if (isSnapshot) {
                ret -= 0.001;
            }
            return ret;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private void loadMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this);
            Metrics.Graph databaseGraph = metrics.createGraph("Database Engine");
            databaseGraph.addPlotter(new Metrics.Plotter(this.database.getName()){

                @Override
                public int getValue() {
                    return 1;
                }
            });
            Metrics.Graph defaultHoldings = metrics.createGraph("Default Holdings");
            defaultHoldings.addPlotter(new Metrics.Plotter(this.getAPI().getDefaultHoldings() + ""){

                @Override
                public int getValue() {
                    return 1;
                }
            });
            Metrics.Graph maxHoldings = metrics.createGraph("Max Holdings");
            String maxHolding = this.getAPI().getMaxHoldings() + "";
            if (this.getAPI().getMaxHoldings() == -1.0) {
                maxHolding = "Unlimited";
            }
            maxHoldings.addPlotter(new Metrics.Plotter(maxHolding){

                @Override
                public int getValue() {
                    return 1;
                }
            });
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setLatestVersion(double latestVersion) {
        this.latestVersion = latestVersion;
    }

    protected void setLatestVersionString(String latestVersionString) {
        this.latestVersionString = latestVersionString;
    }

    public double getLatestVersion() {
        return this.latestVersion;
    }

    public String getLatestVersionString() {
        return this.latestVersionString;
    }

    public boolean isUpdated() {
        return this.currentVersion >= this.latestVersion;
    }

    private void setupVault() {
        Plugin vault = this.getServer().getPluginManager().getPlugin("Vault");
        if (vault == null) {
            return;
        }
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.getServer().getServicesManager().unregister(economyProvider.getProvider());
        }
        this.getServer().getServicesManager().register(Economy.class, (Object)new Economy_Fe((Plugin)this), (Plugin)this, ServicePriority.Highest);
    }

    public void onDisable() {
        this.getServer().getServicesManager().unregisterAll((Plugin)this);
        this.getFeDatabase().close();
    }

    public void log(String message) {
        this.log.info("[Fe] " + message);
    }

    public void log(Phrase phrase, String ... args) {
        this.log(phrase.parse(args));
    }

    public Database getFeDatabase() {
        return this.database;
    }

    public API getAPI() {
        return this.api;
    }

    private boolean setupDatabase() {
        String type = this.getConfig().getString("type");
        this.database = null;
        for (Database database : this.databases) {
            if (!type.equalsIgnoreCase(database.getConfigName())) continue;
            try {
                this.database = database;
                break;
            }
            catch (Exception e) {
            }
        }
        if (this.database == null) {
            this.log(Phrase.DATABASE_TYPE_DOES_NOT_EXIST, new String[0]);
            return false;
        }
        if (!this.database.init()) {
            this.log(Phrase.DATABASE_FAILURE_DISABLE, new String[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
        return true;
    }

    private void setupPhrases() {
        File phrasesFile = new File(this.getDataFolder(), "phrases.yml");
        for (Phrase phrase : Phrase.values()) {
            phrase.reset();
        }
        if (!phrasesFile.exists()) {
            return;
        }
        YamlConfiguration phrasesConfig = YamlConfiguration.loadConfiguration((File)phrasesFile);
        for (Phrase phrase : Phrase.values()) {
            String phraseConfigName = phrase.getConfigName();
            phrase.setMessage(phrasesConfig.getString(phraseConfigName, phrase.parse(new String[0])));
        }
    }

    public void reloadConfig() {
        super.reloadConfig();
        String oldCurrencySingle = this.getConfig().getString("currency.single");
        String oldCurrencyMultiple = this.getConfig().getString("currency.multiple");
        if (oldCurrencySingle != null) {
            this.getConfig().set("currency.major.single", (Object)oldCurrencySingle);
            this.getConfig().set("currency.single", null);
        }
        if (oldCurrencyMultiple != null) {
            this.getConfig().set("currency.major.multiple", (Object)oldCurrencyMultiple);
            this.getConfig().set("currency.multiple", null);
        }
        this.setupPhrases();
        this.saveConfig();
    }

    public String getReadName(Account account) {
        return this.getReadName(account.getName());
    }

    public String getReadName(String name) {
        name = name.toLowerCase();
        OfflinePlayer player = this.getServer().getOfflinePlayer(name);
        if (player != null) {
            name = player.getName();
        }
        return name;
    }

    public Account getShortenedAccount(String name) {
        Player player;
        Account account = this.getAPI().getAccount(name);
        if (account == null && (player = this.getServer().getPlayer(name)) != null) {
            account = this.getAPI().getAccount(player.getName());
        }
        return account;
    }

    public String getMessagePrefix() {
        String third = Phrase.TERTIARY_COLOR.parse(new String[0]);
        return third + "[" + Phrase.PRIMARY_COLOR.parse(new String[0]) + "$1" + third + "] " + Phrase.SECONDARY_COLOR.parse(new String[0]);
    }

    public String getEqualMessage(String inBetween, int length) {
        return this.getEqualMessage(inBetween, length, length);
    }

    public String getEqualMessage(String inBetween, int length, int length2) {
        String equals = this.getEndEqualMessage(length);
        String end = this.getEndEqualMessage(length2);
        String third = Phrase.TERTIARY_COLOR.parse(new String[0]);
        return equals + third + "[" + Phrase.PRIMARY_COLOR.parse(new String[0]) + inBetween + third + "]" + end;
    }

    public String getEndEqualMessage(int length) {
        String message = Phrase.SECONDARY_COLOR.parse(new String[0]) + "";
        for (int i = 0; i < length; ++i) {
            message = message + "=";
        }
        return message;
    }
}

