/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.command.CommandType;
import org.melonbrew.fe.command.SubCommand;
import org.melonbrew.fe.command.commands.BalanceCommand;
import org.melonbrew.fe.command.commands.CleanCommand;
import org.melonbrew.fe.command.commands.ConvertCommand;
import org.melonbrew.fe.command.commands.CreateCommand;
import org.melonbrew.fe.command.commands.DeductCommand;
import org.melonbrew.fe.command.commands.GrantCommand;
import org.melonbrew.fe.command.commands.HelpCommand;
import org.melonbrew.fe.command.commands.ReloadCommand;
import org.melonbrew.fe.command.commands.RemoveCommand;
import org.melonbrew.fe.command.commands.SendCommand;
import org.melonbrew.fe.command.commands.SetCommand;
import org.melonbrew.fe.command.commands.TopCommand;

public class FeCommand
implements CommandExecutor {
    private final List<SubCommand> commands = new ArrayList<SubCommand>();

    public FeCommand(Fe plugin) {
        this.commands.add(new BalanceCommand(plugin));
        this.commands.add(new SendCommand(plugin));
        this.commands.add(new TopCommand(plugin));
        this.commands.add(new HelpCommand(plugin, this));
        this.commands.add(new CreateCommand(plugin));
        this.commands.add(new RemoveCommand(plugin));
        this.commands.add(new SetCommand(plugin));
        this.commands.add(new GrantCommand(plugin));
        this.commands.add(new DeductCommand(plugin));
        this.commands.add(new CleanCommand(plugin));
        this.commands.add(new ConvertCommand(plugin));
        this.commands.add(new ReloadCommand(plugin));
    }

    public List<SubCommand> getCommands() {
        return this.commands;
    }

    private SubCommand getCommand(String name) {
        for (SubCommand command : this.commands) {
            String[] aliases;
            for (String alias : aliases = command.getName().split(",")) {
                if (!alias.equalsIgnoreCase(name)) continue;
                return command;
            }
        }
        return null;
    }

    private String[] merge(String[] ... arrays) {
        int arraySize = 0;
        for (String[] array : arrays) {
            arraySize += array.length;
        }
        String[] result = new String[arraySize];
        int j = 0;
        String[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] array;
            for (String string : array = arr$[i$]) {
                result[j++] = string;
            }
        }
        return result;
    }

    private void sendDefaultCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String command = sender instanceof Player ? "balance" : "help";
        this.onCommand(sender, cmd, commandLabel, this.merge({command}, args));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        boolean console;
        if (args.length < 1) {
            this.sendDefaultCommand(sender, cmd, commandLabel, args);
            return true;
        }
        SubCommand command = this.getCommand(args[0]);
        if (command == null) {
            this.sendDefaultCommand(sender, cmd, commandLabel, args);
            return true;
        }
        boolean bl = console = !(sender instanceof Player);
        if (console && args.length < 2 && command.getCommandType() == CommandType.CONSOLE_WITH_ARGUMENTS) {
            Phrase.COMMAND_NEEDS_ARGUMENTS.sendWithPrefix(sender, new String[0]);
            return true;
        }
        if (console && command.getCommandType() == CommandType.PLAYER) {
            Phrase.COMMAND_NOT_CONSOLE.sendWithPrefix(sender, commandLabel);
            return true;
        }
        if (!sender.hasPermission(command.getPermission())) {
            Phrase.NO_PERMISSION_FOR_COMMAND.sendWithPrefix(sender, new String[0]);
            return true;
        }
        String[] realArgs = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            realArgs[i - 1] = args[i];
        }
        if (!command.onCommand(sender, cmd, commandLabel, realArgs)) {
            Phrase.TRY_COMMAND.sendWithPrefix(sender, this.parse(commandLabel, command));
        }
        return true;
    }

    public String parse(String label, SubCommand command) {
        String[] split;
        String commandColor = Phrase.PRIMARY_COLOR.parse(new String[0]);
        String operatorsColor = Phrase.PRIMARY_COLOR.parse(new String[0]);
        String argumentColor = Phrase.ARGUMENT_COLOR.parse(new String[0]);
        StringBuilder builder = new StringBuilder(commandColor).append("/").append(label);
        if (!command.getFirstName().equalsIgnoreCase("balance")) {
            builder.append(" ").append(command.getFirstName()).append(" ");
        }
        if ((split = command.getUsage().split(" "))[0].equalsIgnoreCase(command.getFirstName())) {
            for (int i = 1; i < split.length; ++i) {
                builder.append(this.parseArg(split[i], operatorsColor, argumentColor)).append(" ");
            }
            builder.deleteCharAt(builder.length() - 1);
        } else {
            builder.append(" ").append(this.parseArg(split[0], operatorsColor, argumentColor)).append(" ");
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private String parseArg(String argument, String operatorsColor, String argumentColor) {
        String operator = argument.substring(0, 1);
        argument = argument.substring(1, argument.length());
        String reverse = operator.equals("[") ? "]" : ")";
        argument = argument.substring(0, argument.length() - 1);
        argument = operatorsColor + operator + argumentColor + argument + operatorsColor + reverse;
        return argument;
    }
}

