/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.SQLibrary;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.melonbrew.fe.SQLibrary.Database;

public class MySQL
extends Database {
    private String hostname = "localhost";
    private String portnmbr = "3306";
    private String username = "minecraft";
    private String password = "";
    private String database = "minecraft";

    public MySQL(Logger log, String prefix, String hostname, String portnmbr, String database, String username, String password) {
        super(log, prefix, "[MySQL] ");
        this.hostname = hostname;
        this.portnmbr = portnmbr;
        this.database = database;
        this.username = username;
        this.password = password;
    }

    @Override
    protected boolean initialize() {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.writeError("Class Not Found Exception: " + e.getMessage() + ".", true);
            return false;
        }
    }

    @Override
    public Connection open() {
        if (this.initialize()) {
            String url = "";
            try {
                url = "jdbc:mysql://" + this.hostname + ":" + this.portnmbr + "/" + this.database;
                this.connection = DriverManager.getConnection(url, this.username, this.password);
            }
            catch (SQLException e) {
                this.writeError(url, true);
                this.writeError("Could not be resolved because of an SQL Exception: " + e.getMessage() + ".", true);
            }
        }
        return null;
    }

    @Override
    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception e) {
            this.writeError("Failed to close database connection: " + e.getMessage(), true);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean checkConnection() {
        if (this.connection == null) {
            return false;
        }
        try {
            return !this.connection.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public ResultSet query(String query) {
        Statement statement = null;
        ResultSet result = null;
        try {
            statement = this.connection.createStatement();
            result = statement.executeQuery("SELECT CURTIME()");
            switch (this.getStatement(query)) {
                case SELECT: {
                    result = statement.executeQuery(query);
                    break;
                }
                default: {
                    statement.executeUpdate(query);
                }
            }
            return result;
        }
        catch (SQLException e) {
            this.writeError("Error in SQL query: " + e.getMessage(), false);
            return result;
        }
    }

    @Override
    public PreparedStatement prepare(String query) {
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(query);
            return ps;
        }
        catch (SQLException e) {
            if (!e.toString().contains("not return ResultSet")) {
                this.writeError("Error in SQL prepare() query: " + e.getMessage(), false);
            }
            return ps;
        }
    }

    @Override
    public boolean createTable(String query) {
        Statement statement = null;
        try {
            if (query == null || query.equals("")) {
                this.writeError("SQL query empty: createTable(" + query + ")", true);
                return false;
            }
            statement = this.connection.createStatement();
            statement.execute(query);
            return true;
        }
        catch (SQLException e) {
            this.writeError(e.getMessage(), true);
            return false;
        }
        catch (Exception e) {
            this.writeError(e.getMessage(), true);
            return false;
        }
    }

    @Override
    public boolean checkTable(String table) {
        try {
            Statement statement = this.connection.createStatement();
            statement.executeQuery("SELECT * FROM " + table);
            return true;
        }
        catch (SQLException e) {
            if (e.getMessage().contains("exist")) {
                return false;
            }
            this.writeError("Error in SQL query: " + e.getMessage(), false);
            return this.query("SELECT * FROM " + table) == null;
        }
    }

    @Override
    public boolean wipeTable(String table) {
        Statement statement = null;
        String query = null;
        try {
            if (!this.checkTable(table)) {
                this.writeError("Error wiping table: \"" + table + "\" does not exist.", true);
                return false;
            }
            statement = this.connection.createStatement();
            query = "DELETE FROM " + table + ";";
            statement.executeUpdate(query);
            return true;
        }
        catch (SQLException e) {
            if (!e.toString().contains("not return ResultSet")) {
                return false;
            }
            return false;
        }
    }
}

