/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.command.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.command.CommandType;
import org.melonbrew.fe.command.SubCommand;
import org.melonbrew.fe.database.Account;

public class BalanceCommand
extends SubCommand {
    private final Fe plugin;

    public BalanceCommand(Fe plugin) {
        super("balance,bal", "fe.balance", "(name)", Phrase.COMMAND_BALANCE, CommandType.CONSOLE_WITH_ARGUMENTS);
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (args.length > 0 && sender.hasPermission("fe.balance.other")) {
            Account account = this.plugin.getShortenedAccount(args[0]);
            if (account == null) {
                Phrase.ACCOUNT_DOES_NOT_EXIST.sendWithPrefix(sender, new String[0]);
                return true;
            }
            Phrase.ACCOUNT_HAS.sendWithPrefix(sender, this.plugin.getReadName(account), this.plugin.getAPI().format(account));
        } else {
            Account account = this.plugin.getAPI().getAccount(sender.getName());
            if (account == null) {
                Phrase.YOUR_ACCOUNT_DOES_NOT_EXIST.sendWithPrefix(sender, new String[0]);
                return true;
            }
            Phrase.YOU_HAVE.sendWithPrefix(sender, this.plugin.getAPI().format(account));
        }
        return true;
    }
}

