/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.command.commands;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.command.CommandType;
import org.melonbrew.fe.command.SubCommand;
import org.melonbrew.fe.database.converter.Converter;
import org.melonbrew.fe.database.converter.converters.Converter_BOSEconomy;
import org.melonbrew.fe.database.converter.converters.Converter_Essentials;
import org.melonbrew.fe.database.converter.converters.Converter_Fe;
import org.melonbrew.fe.database.converter.converters.Converter_iConomy;
import org.melonbrew.fe.database.databases.MySQLDB;

public class ConvertCommand
extends SubCommand {
    private final Fe plugin;
    private final List<Converter> converters;

    public ConvertCommand(Fe plugin) {
        super("convert", "fe.convert", "convert (plugin) (flatfile|mysql)", Phrase.COMMAND_CONVERT, CommandType.CONSOLE);
        this.plugin = plugin;
        this.converters = new ArrayList<Converter>();
        this.converters.add(new Converter_iConomy(plugin));
        this.converters.add(new Converter_Essentials(plugin));
        this.converters.add(new Converter_BOSEconomy(plugin));
        this.converters.add(new Converter_Fe(plugin));
    }

    private void sendConversionList(CommandSender sender) {
        String message = this.plugin.getEqualMessage(Phrase.CONVERSION.parse(new String[0]), 7);
        sender.sendMessage(message);
        for (Converter converter : this.converters) {
            message = ChatColor.GOLD + converter.getName();
            message = message + " " + ChatColor.DARK_GRAY + "(" + ChatColor.YELLOW;
            if (converter.isFlatFile()) {
                message = message + Phrase.FLAT_FILE.parse(new String[0]);
            }
            if (converter.isMySQL()) {
                if (converter.isFlatFile()) {
                    message = message + ", ";
                }
                message = message + Phrase.MYSQL.parse(new String[0]);
            }
            message = message + ChatColor.DARK_GRAY + ")";
            sender.sendMessage(message);
        }
        sender.sendMessage(this.plugin.getEndEqualMessage(31));
    }

    private Converter getConverter(String name) {
        for (Converter converter : this.converters) {
            if (!converter.getName().equalsIgnoreCase(name)) continue;
            return converter;
        }
        return null;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (args.length < 1) {
            this.sendConversionList(sender);
            return true;
        }
        if (args.length < 2) {
            return false;
        }
        String type = args[1];
        String flatfile = Phrase.FLAT_FILE.parseWithoutSpaces(new String[0]);
        String mysql = Phrase.MYSQL.parseWithoutSpaces(new String[0]);
        if (!type.equalsIgnoreCase(flatfile) && !type.equalsIgnoreCase(mysql)) {
            return false;
        }
        Converter converter = this.getConverter(args[0]);
        if (converter == null) {
            Phrase.CONVERTER_DOES_NOT_EXIST.sendWithPrefix(sender, new String[0]);
            return true;
        }
        String supported = null;
        if (type.equalsIgnoreCase(flatfile) && !converter.isFlatFile()) {
            supported = Phrase.FLAT_FILE.parse(new String[0]);
        } else if (type.equalsIgnoreCase(mysql)) {
            if (!converter.mySQLtoFlatFile() && !(this.plugin.getFeDatabase() instanceof MySQLDB)) {
                Phrase.CONVERTER_DOES_NOT_SUPPORT.sendWithPrefix(sender, Phrase.MYSQL_TO_FLAT_FILE.parse(new String[0]));
                return true;
            }
            if (!converter.isMySQL()) {
                supported = Phrase.MYSQL.parse(new String[0]);
            }
        }
        if (supported != null) {
            Phrase.CONVERTER_DOES_NOT_SUPPORT.sendWithPrefix(sender, supported);
            return true;
        }
        boolean success = type.equalsIgnoreCase(flatfile) ? converter.convertFlatFile() : converter.convertMySQL();
        if (success) {
            Phrase.CONVERSION_SUCCEEDED.sendWithPrefix(sender, new String[0]);
        } else {
            Phrase.CONVERSION_FAILED.sendWithPrefix(sender, new String[0]);
        }
        return true;
    }
}

