/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.command.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.command.CommandType;
import org.melonbrew.fe.command.SubCommand;
import org.melonbrew.fe.database.Account;

public class DeductCommand
extends SubCommand {
    private final Fe plugin;

    public DeductCommand(Fe plugin) {
        super("deduct", "fe.deduct", "deduct [name] [amount]", Phrase.COMMAND_DEDUCT, CommandType.CONSOLE);
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        double money;
        if (args.length < 2) {
            return false;
        }
        try {
            money = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        Account victim = this.plugin.getShortenedAccount(args[0]);
        if (victim == null) {
            Phrase.ACCOUNT_DOES_NOT_EXIST.sendWithPrefix(sender, new String[0]);
            return true;
        }
        String victimName = this.plugin.getReadName(victim);
        String formattedMoney = this.plugin.getAPI().format(money);
        victim.withdraw(money);
        Phrase.PLAYER_DEDUCT_MONEY.sendWithPrefix(sender, formattedMoney, this.plugin.getReadName(victim));
        Player recieverPlayer = this.plugin.getServer().getPlayerExact(victimName);
        if (recieverPlayer != null) {
            Phrase.PLAYER_DEDUCTED_MONEY.sendWithPrefix((CommandSender)recieverPlayer, formattedMoney, sender.getName());
        }
        return true;
    }
}

