/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.command.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.Phrase;
import org.melonbrew.fe.command.CommandType;
import org.melonbrew.fe.command.SubCommand;
import org.melonbrew.fe.database.Account;

public class SendCommand
extends SubCommand {
    private final Fe plugin;

    public SendCommand(Fe plugin) {
        super("send,pay,give", "fe.send", "send [name] [amount]", Phrase.COMMAND_SEND, CommandType.PLAYER);
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        double money;
        if (args.length < 2) {
            return false;
        }
        try {
            money = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (money <= 0.0) {
            return false;
        }
        Account reciever = this.plugin.getShortenedAccount(args[0]);
        if (reciever == null) {
            Phrase.ACCOUNT_DOES_NOT_EXIST.sendWithPrefix(sender, new String[0]);
            return true;
        }
        Account account = this.plugin.getAPI().getAccount(sender.getName());
        if (!account.has(money)) {
            Phrase.NOT_ENOUGH_MONEY.sendWithPrefix(sender, new String[0]);
            return true;
        }
        String recieverName = this.plugin.getReadName(reciever);
        if (!reciever.canRecieve(money)) {
            Phrase.MAX_BALANCE_REACHED.sendWithPrefix(sender, recieverName);
            return true;
        }
        String formattedMoney = this.plugin.getAPI().format(money);
        account.withdraw(money);
        reciever.deposit(money);
        Phrase.MONEY_SENT.sendWithPrefix(sender, formattedMoney, recieverName);
        Player recieverPlayer = this.plugin.getServer().getPlayerExact(reciever.getName());
        if (recieverPlayer != null) {
            Phrase.MONEY_RECIEVE.sendWithPrefix((CommandSender)recieverPlayer, formattedMoney, sender.getName());
        }
        return true;
    }
}

