/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.database;

import org.melonbrew.fe.API;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.database.Database;

public class Account {
    private final String name;
    private final API api;
    private final Database database;

    public Account(String name, Fe plugin, Database database) {
        this.name = name;
        this.api = plugin.getAPI();
        this.database = database;
    }

    public String getName() {
        return this.name;
    }

    public double getMoney() {
        return this.database.loadAccountMoney(this.name);
    }

    public void withdraw(double amount) {
        this.setMoney(this.getMoney() - amount);
    }

    public void deposit(double amount) {
        this.setMoney(this.getMoney() + amount);
    }

    public boolean canRecieve(double amount) {
        if (this.api.getMaxHoldings() == -1.0) {
            return true;
        }
        return amount + this.getMoney() < this.api.getMaxHoldings();
    }

    public void setMoney(double money) {
        double currentMoney = this.getMoney();
        if (currentMoney == money) {
            return;
        }
        if (money < 0.0 && !this.api.isCurrencyNegative()) {
            money = 0.0;
        }
        currentMoney = this.api.getMoneyRounded(money);
        if (this.api.getMaxHoldings() != -1.0 && currentMoney > this.api.getMaxHoldings()) {
            currentMoney = this.api.getMoneyRounded(this.api.getMaxHoldings());
        }
        this.save(currentMoney);
    }

    public boolean has(double amount) {
        return this.getMoney() >= amount;
    }

    public void save(double money) {
        this.database.saveAccount(this.name, money);
    }
}

