/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.database.converter.converters;

import org.melonbrew.fe.Fe;
import org.melonbrew.fe.database.Account;
import org.melonbrew.fe.database.Database;
import org.melonbrew.fe.database.converter.Converter;
import org.melonbrew.fe.database.databases.MySQLDB;
import org.melonbrew.fe.database.databases.SQLiteDB;

public class Converter_Fe
extends Converter {
    private final Fe plugin;

    public Converter_Fe(Fe plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "Fe";
    }

    @Override
    public boolean isFlatFile() {
        return true;
    }

    @Override
    public boolean isMySQL() {
        return true;
    }

    @Override
    public boolean mySQLtoFlatFile() {
        return true;
    }

    public boolean convert(Database database) {
        if (!database.init()) {
            return false;
        }
        for (Account account : database.getAccounts()) {
            this.plugin.getAPI().createAccount(account.getName()).setMoney(account.getMoney());
        }
        return true;
    }

    @Override
    public boolean convertFlatFile() {
        if (this.plugin.getFeDatabase() instanceof SQLiteDB) {
            return false;
        }
        return this.convert(new SQLiteDB(this.plugin));
    }

    @Override
    public boolean convertMySQL() {
        if (this.plugin.getFeDatabase() instanceof MySQLDB) {
            return false;
        }
        return this.convert(new MySQLDB(this.plugin));
    }
}

