/*
 * Decompiled with CFR 0.152.
 */
package org.melonbrew.fe.database.databases;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.melonbrew.fe.Fe;
import org.melonbrew.fe.database.Account;
import org.melonbrew.fe.database.Database;

public abstract class SQLDB
extends Database {
    private final Fe plugin;
    private final boolean supportsModification;
    private org.melonbrew.fe.SQLibrary.Database database;
    private String accounts;

    public SQLDB(Fe plugin, boolean supportsModification) {
        super(plugin);
        this.plugin = plugin;
        this.supportsModification = supportsModification;
        this.accounts = "fe_accounts";
    }

    public void setAccountTable(String accounts) {
        this.accounts = accounts;
    }

    @Override
    public boolean init() {
        this.database = this.getNewDatabase();
        return this.checkConnection();
    }

    public boolean checkConnection() {
        if (!this.database.checkConnection()) {
            this.database.open();
            if (!this.database.checkConnection()) {
                return false;
            }
            if (!this.database.createTable("CREATE TABLE IF NOT EXISTS " + this.accounts + "(name varchar(64), money double);")) {
                return false;
            }
            if (this.supportsModification) {
                this.database.query("ALTER TABLE " + this.accounts + " MODIFY name varchar(64)");
            }
        }
        return true;
    }

    protected abstract org.melonbrew.fe.SQLibrary.Database getNewDatabase();

    public org.melonbrew.fe.SQLibrary.Database getDatabase() {
        return this.database;
    }

    @Override
    public void close() {
        this.database.close();
    }

    @Override
    public List<Account> getTopAccounts() {
        this.checkConnection();
        String sql = "SELECT name FROM " + this.accounts + " ORDER BY money DESC limit 5";
        ArrayList<Account> topAccounts = new ArrayList<Account>();
        ResultSet set = this.database.query(sql);
        try {
            while (set.next()) {
                topAccounts.add(this.getAccount(set.getString("name")));
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return topAccounts;
    }

    @Override
    public List<Account> getAccounts() {
        this.checkConnection();
        String sql = "SELECT name FROM " + this.accounts;
        ArrayList<Account> accounts = new ArrayList<Account>();
        ResultSet set = this.database.query(sql);
        try {
            while (set.next()) {
                accounts.add(this.getAccount(set.getString("name")));
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return accounts;
    }

    @Override
    public double loadAccountMoney(String name) {
        this.checkConnection();
        String sql = "SELECT * FROM " + this.accounts + " WHERE name=?";
        double money = -1.0;
        try {
            PreparedStatement prest = this.database.prepare(sql);
            prest.setString(1, name);
            ResultSet set = prest.executeQuery();
            while (set.next()) {
                money = set.getDouble("money");
            }
            prest.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1.0;
        }
        return money;
    }

    @Override
    public void removeAccount(String name) {
        this.checkConnection();
        String sql = "DELETE FROM " + this.accounts + " WHERE name=?";
        try {
            PreparedStatement prest = this.database.prepare(sql);
            prest.setString(1, name);
            prest.execute();
            prest.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    protected void saveAccount(String name, double money) {
        this.checkConnection();
        if (this.accountExists(name)) {
            String sql = "UPDATE " + this.accounts + " SET money=? WHERE name=?";
            try {
                PreparedStatement prest = this.database.prepare(sql);
                prest.setDouble(1, money);
                prest.setString(2, name);
                prest.executeUpdate();
                prest.close();
            }
            catch (SQLException e) {}
        } else {
            String sql = "INSERT INTO " + this.accounts + " (name, money) VALUES (?, ?)";
            try {
                PreparedStatement prest = this.database.prepare(sql);
                prest.setString(1, name);
                prest.setDouble(2, money);
                prest.executeUpdate();
                prest.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void clean() {
        this.checkConnection();
        String sql = "SELECT * FROM " + this.accounts + " WHERE money=?";
        try {
            PreparedStatement prest = this.database.prepare(sql);
            prest.setDouble(1, this.plugin.getAPI().getDefaultHoldings());
            ResultSet set = prest.executeQuery();
            boolean executeQuery = false;
            StringBuilder builder = new StringBuilder("DELETE FROM " + this.accounts + " WHERE name IN (");
            while (set.next()) {
                String name = set.getString("name");
                if (this.plugin.getServer().getPlayerExact(name) != null) continue;
                executeQuery = true;
                builder.append("'").append(name).append("', ");
            }
            prest.close();
            builder.delete(0, builder.length() - 2).append(")");
            if (executeQuery) {
                this.database.query(builder.toString());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

