/*
 * Decompiled with CFR 0.152.
 */
package org.yi.acru.bukkit.Lockette;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.yi.acru.bukkit.Lockette.Lockette;
import org.yi.acru.bukkit.PluginCore;

public class LocketteBlockListener
implements Listener {
    private static Lockette plugin;
    static byte[] faceList;
    final int[] materialList = new int[]{Material.CHEST.getId(), Material.TRAPPED_CHEST.getId(), Material.DISPENSER.getId(), Material.DROPPER.getId(), Material.FURNACE.getId(), Material.BURNING_FURNACE.getId(), Material.BREWING_STAND.getId(), Material.TRAP_DOOR.getId(), Material.WOODEN_DOOR.getId(), Material.IRON_DOOR_BLOCK.getId(), Material.FENCE_GATE.getId()};
    final int[] materialListFurnaces = new int[]{Material.FURNACE.getId(), Material.BURNING_FURNACE.getId()};
    final int[] materialListDoors = new int[]{Material.WOODEN_DOOR.getId(), Material.IRON_DOOR_BLOCK.getId(), Material.FENCE_GATE.getId()};
    final int[] materialListBad = new int[]{50, 63, 64, 65, 68, 71, 75, 76, 96};

    static {
        faceList = new byte[]{5, 3, 4, 2};
        if (BlockFace.NORTH.getModX() != -1) {
            LocketteBlockListener.faceList[0] = 3;
            LocketteBlockListener.faceList[1] = 4;
            LocketteBlockListener.faceList[2] = 2;
            LocketteBlockListener.faceList[3] = 5;
        }
    }

    public LocketteBlockListener(Lockette instance) {
        plugin = instance;
    }

    protected void registerEvents() {
        PluginManager pm = plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        int type = block.getTypeId();
        if (event.isCancelled() && type != Material.WOODEN_DOOR.getId()) {
            return;
        }
        if (type == Material.WALL_SIGN.getId()) {
            Sign sign;
            String text;
            if (block.getData() == 0) {
                block.setData((byte)5);
            }
            if ((text = (sign = (Sign)block.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[private]") || text.equalsIgnoreCase(Lockette.altPrivate)) {
                int length = player.getName().length();
                if (length > 15) {
                    length = 15;
                }
                if (sign.getLine(1).replaceAll("(?i)\u00a7[0-F]", "").equals(player.getName().substring(0, length))) {
                    Lockette.log.info("[" + plugin.getDescription().getName() + "] " + player.getName() + " has released a container.");
                    plugin.localizedMessage(player, null, "msg-owner-release");
                    return;
                }
                if (Lockette.adminBreak) {
                    boolean snoop = false;
                    if (plugin.hasPermission(block.getWorld(), player, "lockette.admin.break")) {
                        snoop = true;
                    }
                    if (snoop) {
                        Lockette.log.info("[" + plugin.getDescription().getName() + "] (Admin) " + player.getName() + " has broken open a container owned by " + sign.getLine(1) + "!");
                        plugin.localizedMessage(player, Lockette.broadcastBreakTarget, "msg-admin-release", sign.getLine(1));
                        return;
                    }
                }
                event.setCancelled(true);
                sign.update();
                plugin.localizedMessage(player, null, "msg-user-release-owned", sign.getLine(1));
            } else if (text.equals("[more users]") || text.equalsIgnoreCase(Lockette.altMoreUsers)) {
                Block checkBlock = Lockette.getSignAttachedBlock(block);
                if (checkBlock == null) {
                    return;
                }
                Block signBlock = Lockette.findBlockOwner(checkBlock);
                if (signBlock == null) {
                    return;
                }
                Sign sign2 = (Sign)signBlock.getState();
                int length = player.getName().length();
                if (length > 15) {
                    length = 15;
                }
                if (sign2.getLine(1).replaceAll("(?i)\u00a7[0-F]", "").equals(player.getName().substring(0, length))) {
                    plugin.localizedMessage(player, null, "msg-owner-remove");
                    return;
                }
                event.setCancelled(true);
                sign.update();
                plugin.localizedMessage(player, null, "msg-user-remove-owned", sign2.getLine(1));
            }
        } else {
            Block signBlock = Lockette.findBlockOwner(block);
            if (signBlock == null) {
                return;
            }
            Sign sign = (Sign)signBlock.getState();
            int length = player.getName().length();
            if (length > 15) {
                length = 15;
            }
            if (sign.getLine(1).replaceAll("(?i)\u00a7[0-F]", "").equals(player.getName().substring(0, length))) {
                if (Lockette.findBlockOwnerBreak(block) != null) {
                    Lockette.log.info("[" + plugin.getDescription().getName() + "] " + player.getName() + " has released a container.");
                } else if (type != Material.WOODEN_DOOR.getId()) {
                    Material.IRON_DOOR_BLOCK.getId();
                }
                return;
            }
            event.setCancelled(true);
            plugin.localizedMessage(player, null, "msg-user-break-owned", sign.getLine(1));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        Block checkBlock;
        Block block = event.getBlock();
        List blockList = event.getBlocks();
        int count = blockList.size();
        int x = 0;
        while (x < count) {
            checkBlock = (Block)blockList.get(x);
            if (Lockette.isProtected(checkBlock)) {
                event.setCancelled(true);
                return;
            }
            ++x;
        }
        checkBlock = block.getRelative(Lockette.getPistonFacing(block), event.getLength() + 1);
        if (Lockette.isProtected(checkBlock)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (!event.isSticky()) {
            return;
        }
        Block block = event.getBlock();
        Block checkBlock = block.getRelative(Lockette.getPistonFacing(block), 2);
        int type = checkBlock.getTypeId();
        if (type == Material.CHEST.getId()) {
            return;
        }
        if (type == Material.TRAPPED_CHEST.getId()) {
            return;
        }
        if (type == Material.DISPENSER.getId()) {
            return;
        }
        if (type == Material.DROPPER.getId()) {
            return;
        }
        if (type == Material.FURNACE.getId()) {
            return;
        }
        if (type == Material.BURNING_FURNACE.getId()) {
            return;
        }
        if (type == Material.WOODEN_DOOR.getId()) {
            return;
        }
        if (type == Material.IRON_DOOR_BLOCK.getId()) {
            return;
        }
        if (Lockette.isProtected(checkBlock)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Sign sign;
        String text;
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlockPlaced();
        int type = block.getTypeId();
        Block against = event.getBlockAgainst();
        if (against.getTypeId() == Material.WALL_SIGN.getId() && ((text = (sign = (Sign)against.getState()).getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase()).equals("[private]") || text.equalsIgnoreCase(Lockette.altPrivate) || text.equals("[more users]") || text.equalsIgnoreCase(Lockette.altMoreUsers))) {
            event.setCancelled(true);
            return;
        }
        if (type == Material.WOODEN_DOOR.getId() || type == Material.IRON_DOOR_BLOCK.getId() || type == Material.TRAP_DOOR.getId() || type == Material.FENCE_GATE.getId()) {
            if (LocketteBlockListener.canBuildDoor(block, against, player)) {
                return;
            }
            event.setCancelled(true);
            plugin.localizedMessage(player, null, "msg-user-conflict-door");
            return;
        }
        if (Lockette.directPlacement && type == Material.WALL_SIGN.getId()) {
            Block checkBlock = Lockette.getSignAttachedBlock(block);
            if (checkBlock == null) {
                return;
            }
            type = checkBlock.getTypeId();
            if (type == Material.CHEST.getId() || type == Material.TRAPPED_CHEST.getId() || type == Material.DISPENSER.getId() || type == Material.DROPPER.getId() || type == Material.FURNACE.getId() || type == Material.BURNING_FURNACE.getId() || type == Material.BREWING_STAND.getId() || Lockette.isInList(type, Lockette.customBlockList)) {
                sign = (Sign)block.getState();
                int length = player.getName().length();
                if (length > 15) {
                    length = 15;
                }
                if (Lockette.isProtected(checkBlock)) {
                    if (Lockette.isOwner(checkBlock, player.getName())) {
                        sign.setLine(0, Lockette.altMoreUsers);
                        sign.setLine(1, Lockette.altEveryone);
                        sign.setLine(2, "");
                        sign.setLine(3, "");
                        sign.update(true);
                        plugin.localizedMessage(player, null, "msg-owner-adduser");
                    } else {
                        event.setCancelled(true);
                    }
                    return;
                }
                if (!this.checkPermissions(player, block, checkBlock)) {
                    event.setCancelled(true);
                    plugin.localizedMessage(player, null, "msg-error-permission");
                    return;
                }
                sign.setLine(0, Lockette.altPrivate);
                sign.setLine(1, player.getName().substring(0, length));
                sign.setLine(2, "");
                sign.setLine(3, "");
                sign.update(true);
                Lockette.log.info("[" + plugin.getDescription().getName() + "] " + player.getName() + " has protected a block or door.");
                plugin.localizedMessage(player, null, "msg-owner-claim");
            }
            return;
        }
        if (type == Material.CHEST.getId() || type == Material.TRAPPED_CHEST.getId()) {
            int chests = Lockette.findChestCountNear(block);
            if (chests > 1) {
                event.setCancelled(true);
                plugin.localizedMessage(player, null, "msg-user-illegal");
                return;
            }
            Block signBlock = Lockette.findBlockOwner(block);
            if (signBlock != null) {
                Sign sign2 = (Sign)signBlock.getState();
                int length = player.getName().length();
                if (length > 15) {
                    length = 15;
                }
                if (sign2.getLine(1).replaceAll("(?i)\u00a7[0-F]", "").equals(player.getName().substring(0, length))) {
                    return;
                }
                event.setCancelled(true);
                plugin.localizedMessage(player, null, "msg-user-resize-owned", sign2.getLine(1));
            } else if (LocketteBlockListener.plugin.playerList.get(player.getName()) == null) {
                LocketteBlockListener.plugin.playerList.put(player.getName(), block);
                plugin.localizedMessage(player, null, "msg-help-chest");
            }
        }
        if (type == Material.HOPPER.getId()) {
            Block checkBlock = block.getRelative(BlockFace.UP);
            type = checkBlock.getTypeId();
            if ((type == Material.CHEST.getId() || type == Material.DISPENSER.getId() || type == Material.DROPPER.getId() || type == Material.FURNACE.getId() || type == Material.BURNING_FURNACE.getId() || type == Material.BREWING_STAND.getId() || Lockette.isInList(type, Lockette.customBlockList)) && !this.validateOwner(checkBlock, player)) {
                event.setCancelled(true);
                plugin.localizedMessage(player, null, "msg-user-denied");
                return;
            }
            checkBlock = block.getRelative(BlockFace.DOWN);
            type = checkBlock.getTypeId();
            if ((type == Material.CHEST.getId() || type == Material.DISPENSER.getId() || type == Material.DROPPER.getId() || type == Material.FURNACE.getId() || type == Material.BURNING_FURNACE.getId() || type == Material.BREWING_STAND.getId() || Lockette.isInList(type, Lockette.customBlockList)) && !this.validateOwner(checkBlock, player)) {
                event.setCancelled(true);
                plugin.localizedMessage(player, null, "msg-user-denied");
                return;
            }
        }
    }

    private boolean checkPermissions(Player player, Block block, Block checkBlock) {
        int type = checkBlock.getTypeId();
        if (plugin.usingExternalZones()) {
            if (!plugin.canBuild(player, block)) {
                plugin.localizedMessage(player, null, "msg-error-zone", PluginCore.lastZoneDeny());
                return false;
            }
            if (!plugin.canBuild(player, checkBlock)) {
                plugin.localizedMessage(player, null, "msg-error-zone", PluginCore.lastZoneDeny());
                return false;
            }
        }
        if (plugin.usingExternalPermissions()) {
            boolean create = false;
            if (plugin.hasPermission(block.getWorld(), player, "lockette.create.all")) {
                create = true;
            } else if (type == Material.CHEST.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.chest")) {
                    create = true;
                }
            } else if (type == Material.FURNACE.getId() || type == Material.BURNING_FURNACE.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.furnace")) {
                    create = true;
                }
            } else if (type == Material.DISPENSER.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.dispenser")) {
                    create = true;
                }
            } else if (type == Material.DROPPER.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.dropper")) {
                    create = true;
                }
            } else if (type == Material.BREWING_STAND.getId()) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.user.create.brewingstand")) {
                    create = true;
                }
            } else if (Lockette.isInList(type, Lockette.customBlockList) && plugin.hasPermission(block.getWorld(), player, "lockette.user.create.custom")) {
                create = true;
            }
            return create;
        }
        return true;
    }

    private boolean validateOwner(Block block, Player player) {
        Block signBlock = Lockette.findBlockOwner(block);
        if (signBlock == null) {
            return true;
        }
        Sign sign = (Sign)signBlock.getState();
        int length = player.getName().length();
        if (length > 15) {
            length = 15;
        }
        return sign.getLine(1).replaceAll("(?i)\u00a7[0-F]", "").equals(player.getName().substring(0, length));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        int type = block.getTypeId();
        boolean doCheck = false;
        if (Lockette.protectTrapDoors && type == Material.TRAP_DOOR.getId()) {
            doCheck = true;
        }
        if (Lockette.protectDoors && (type == Material.WOODEN_DOOR.getId() || type == Material.IRON_DOOR_BLOCK.getId() || type == Material.FENCE_GATE.getId())) {
            doCheck = true;
        }
        if (doCheck) {
            String line;
            Block signBlock = Lockette.findBlockOwner(block);
            if (signBlock == null) {
                return;
            }
            Sign sign = (Sign)signBlock.getState();
            int y = 1;
            while (y <= 3) {
                if (!sign.getLine(y).isEmpty() && ((line = sign.getLine(y).replaceAll("(?i)\u00a7[0-F]", "")).equalsIgnoreCase("[Everyone]") || line.equalsIgnoreCase(Lockette.altEveryone))) {
                    return;
                }
                ++y;
            }
            List<Block> list = Lockette.findBlockUsers(block, signBlock);
            int count = list.size();
            int x = 0;
            while (x < count) {
                sign = (Sign)list.get(x).getState();
                y = 1;
                while (y <= 3) {
                    if (!sign.getLine(y).isEmpty() && ((line = sign.getLine(y).replaceAll("(?i)\u00a7[0-F]", "")).equalsIgnoreCase("[Everyone]") || line.equalsIgnoreCase(Lockette.altEveryone))) {
                        return;
                    }
                    ++y;
                }
                ++x;
            }
            event.setNewCurrent(event.getOldCurrent());
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        block124: {
            block106: {
                block107: {
                    player = event.getPlayer();
                    block = event.getBlock();
                    typeWallSign = block.getTypeId() == Material.WALL_SIGN.getId();
                    v0 = typeSignPost = block.getTypeId() == Material.SIGN_POST.getId();
                    if (typeWallSign) {
                        sign = (Sign)block.getState();
                        text = sign.getLine(0).replaceAll("(?i)\u00a7[0-F]", "");
                        if ((text.equalsIgnoreCase("[Private]") || text.equalsIgnoreCase(Lockette.altPrivate) || text.equalsIgnoreCase("[More Users]") || text.equalsIgnoreCase(Lockette.altMoreUsers)) && event.isCancelled()) {
                            return;
                        }
                    } else if (!typeSignPost) {
                        event.setCancelled(true);
                        return;
                    }
                    if (!(text = event.getLine(0).replaceAll("(?i)\u00a7[0-F]", "")).equalsIgnoreCase("[Private]") && !text.equalsIgnoreCase(Lockette.altPrivate)) break block106;
                    doChests = true;
                    doFurnaces = true;
                    doDispensers = true;
                    doDroppers = true;
                    doBrewingStands = true;
                    doCustoms = true;
                    doTrapDoors = true;
                    doDoors = true;
                    if (LocketteBlockListener.plugin.usingExternalZones() && !LocketteBlockListener.plugin.canBuild(player, block)) {
                        event.setLine(0, "[?]");
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-error-zone", PluginCore.lastZoneDeny());
                        return;
                    }
                    if (LocketteBlockListener.plugin.usingExternalPermissions()) {
                        create = false;
                        doChests = false;
                        doFurnaces = false;
                        doDispensers = false;
                        doDroppers = false;
                        doBrewingStands = false;
                        doCustoms = false;
                        doTrapDoors = false;
                        doDoors = false;
                        if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.create.all")) {
                            create = true;
                            doChests = true;
                            doFurnaces = true;
                            doDispensers = true;
                            doDroppers = true;
                            doBrewingStands = true;
                            doCustoms = true;
                            doTrapDoors = true;
                            doDoors = true;
                        } else {
                            if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.user.create.chest")) {
                                create = true;
                                doChests = true;
                            }
                            if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.user.create.furnace")) {
                                create = true;
                                doFurnaces = true;
                            }
                            if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.user.create.dispenser")) {
                                create = true;
                                doDispensers = true;
                            }
                            if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.user.create.dropper")) {
                                create = true;
                                doDroppers = true;
                            }
                            if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.user.create.brewingstand")) {
                                create = true;
                                doBrewingStands = true;
                            }
                            if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.user.create.custom")) {
                                create = true;
                                doCustoms = true;
                            }
                            if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.user.create.trapdoor")) {
                                create = true;
                                doTrapDoors = true;
                            }
                            if (LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.user.create.door")) {
                                create = true;
                                doDoors = true;
                            }
                        }
                        if (!create) {
                            event.setLine(0, "[?]");
                            LocketteBlockListener.plugin.localizedMessage(player, null, "msg-error-permission");
                            return;
                        }
                    }
                    checkBlock = new Block[4];
                    face = 0;
                    type = 0;
                    conflict = false;
                    deny = false;
                    zonedeny = false;
                    if (Lockette.protectTrapDoors && typeWallSign) {
                        checkBlock[3] = Lockette.getSignAttachedBlock(block);
                        if (checkBlock[3] != null && !this.isInList(checkBlock[3].getTypeId(), this.materialListBad)) {
                            checkBlock[0] = checkBlock[3].getRelative(BlockFace.NORTH);
                            checkBlock[1] = checkBlock[3].getRelative(BlockFace.EAST);
                            checkBlock[2] = checkBlock[3].getRelative(BlockFace.SOUTH);
                            checkBlock[3] = checkBlock[3].getRelative(BlockFace.WEST);
                            x = 0;
                            while (x < 4) {
                                if (checkBlock[x].getTypeId() == Material.TRAP_DOOR.getId() && Lockette.findBlockOwner(checkBlock[x], block, true) == null) {
                                    if (!doTrapDoors) {
                                        deny = true;
                                    } else {
                                        face = block.getData();
                                        type = 4;
                                        break;
                                    }
                                }
                                ++x;
                            }
                        }
                    }
                    if (Lockette.protectDoors && typeWallSign) {
                        checkBlock[0] = Lockette.getSignAttachedBlock(block);
                        if (checkBlock[0] != null && !this.isInList(checkBlock[0].getTypeId(), this.materialListBad)) {
                            checkBlock[1] = checkBlock[0].getRelative(BlockFace.UP);
                            checkBlock[2] = checkBlock[0].getRelative(BlockFace.DOWN);
                            if (this.isInList(checkBlock[1].getTypeId(), this.materialListDoors)) {
                                if (Lockette.findBlockOwner(checkBlock[1], block, true) == null) {
                                    if (this.isInList(checkBlock[2].getTypeId(), this.materialListDoors)) {
                                        if (Lockette.findBlockOwner(checkBlock[2], block, true) == null) {
                                            if (!doDoors) {
                                                deny = true;
                                            } else {
                                                face = block.getData();
                                                type = 5;
                                            }
                                        } else {
                                            conflict = true;
                                        }
                                    } else if (!doDoors) {
                                        deny = true;
                                    } else {
                                        face = block.getData();
                                        type = 5;
                                    }
                                } else {
                                    conflict = true;
                                }
                            } else if (this.isInList(checkBlock[2].getTypeId(), this.materialListDoors)) {
                                if (Lockette.findBlockOwner(checkBlock[2], block, true) == null) {
                                    if (!doDoors) {
                                        deny = true;
                                    } else {
                                        face = block.getData();
                                        type = 5;
                                    }
                                } else {
                                    conflict = true;
                                }
                            }
                        }
                    }
                    if (conflict) {
                        face = 0;
                        type = 0;
                    }
                    if (face != 0) break block107;
                    checkBlock[0] = block.getRelative(BlockFace.NORTH);
                    checkBlock[1] = block.getRelative(BlockFace.EAST);
                    checkBlock[2] = block.getRelative(BlockFace.SOUTH);
                    checkBlock[3] = block.getRelative(BlockFace.WEST);
                    x = 0;
                    while (x < 4) {
                        block109: {
                            block122: {
                                block123: {
                                    block120: {
                                        block121: {
                                            block118: {
                                                block119: {
                                                    block116: {
                                                        block117: {
                                                            block114: {
                                                                block115: {
                                                                    block112: {
                                                                        block113: {
                                                                            block110: {
                                                                                block111: {
                                                                                    block108: {
                                                                                        if (!LocketteBlockListener.plugin.usingExternalZones() || LocketteBlockListener.plugin.canBuild(player, checkBlock[x])) break block108;
                                                                                        zonedeny = true;
                                                                                        break block109;
                                                                                    }
                                                                                    if (checkBlock[x].getTypeId() != Material.CHEST.getId() && checkBlock[x].getTypeId() != Material.TRAPPED_CHEST.getId()) break block110;
                                                                                    if (doChests) break block111;
                                                                                    deny = true;
                                                                                    break block109;
                                                                                }
                                                                                lastType = 1;
                                                                                ** GOTO lbl210
                                                                            }
                                                                            if (!this.isInList(checkBlock[x].getTypeId(), this.materialListFurnaces)) break block112;
                                                                            if (doFurnaces) break block113;
                                                                            deny = true;
                                                                            break block109;
                                                                        }
                                                                        lastType = 2;
                                                                        ** GOTO lbl210
                                                                    }
                                                                    if (checkBlock[x].getTypeId() != Material.DISPENSER.getId()) break block114;
                                                                    if (doDispensers) break block115;
                                                                    deny = true;
                                                                    break block109;
                                                                }
                                                                lastType = 3;
                                                                ** GOTO lbl210
                                                            }
                                                            if (checkBlock[x].getTypeId() != Material.DROPPER.getId()) break block116;
                                                            if (doDroppers) break block117;
                                                            deny = true;
                                                            break block109;
                                                        }
                                                        lastType = 8;
                                                        ** GOTO lbl210
                                                    }
                                                    if (checkBlock[x].getTypeId() != Material.BREWING_STAND.getId()) break block118;
                                                    if (doBrewingStands) break block119;
                                                    deny = true;
                                                    break block109;
                                                }
                                                lastType = 6;
                                                ** GOTO lbl210
                                            }
                                            if (!Lockette.isInList(checkBlock[x].getTypeId(), Lockette.customBlockList)) break block120;
                                            if (doCustoms) break block121;
                                            deny = true;
                                            break block109;
                                        }
                                        lastType = 7;
                                        ** GOTO lbl210
                                    }
                                    if (checkBlock[x].getTypeId() != Material.TRAP_DOOR.getId()) break block122;
                                    if (!Lockette.protectTrapDoors) break block109;
                                    if (doTrapDoors) break block123;
                                    deny = true;
                                    break block109;
                                }
                                lastType = 4;
                                ** GOTO lbl210
                            }
                            if (!this.isInList(checkBlock[x].getTypeId(), this.materialListDoors) || !Lockette.protectDoors) break block109;
                            if (!doDoors) {
                                deny = true;
                            } else {
                                lastType = 5;
lbl210:
                                // 8 sources

                                if (Lockette.findBlockOwner(checkBlock[x], block, true) == null) {
                                    face = LocketteBlockListener.faceList[x];
                                    type = lastType;
                                    break;
                                }
                                if (Lockette.protectTrapDoors && doTrapDoors && checkBlock[x].getTypeId() == Material.TRAP_DOOR.getId()) {
                                    conflict = true;
                                }
                                if (Lockette.protectDoors && doDoors && this.isInList(checkBlock[x].getTypeId(), this.materialListDoors)) {
                                    conflict = true;
                                }
                            }
                        }
                        ++x;
                    }
                }
                if (face == 0) {
                    event.setLine(0, "[?]");
                    if (conflict) {
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-error-claim-conflict");
                    } else if (zonedeny) {
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-error-zone", PluginCore.lastZoneDeny());
                    } else if (deny) {
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-error-permission");
                    } else {
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-error-claim");
                    }
                    return;
                }
                anyone = true;
                length = player.getName().length();
                if (event.getLine(1).isEmpty()) {
                    anyone = false;
                }
                if (length > 15) {
                    length = 15;
                }
                event.setCancelled(false);
                if (anyone) {
                    if (type == 1) {
                        if (!LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.chest")) {
                            anyone = false;
                        }
                    } else if (type == 2) {
                        if (!LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.furnace")) {
                            anyone = false;
                        }
                    } else if (type == 3) {
                        if (!LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.dispenser")) {
                            anyone = false;
                        }
                    } else if (type == 8) {
                        if (!LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.dropper")) {
                            anyone = false;
                        }
                    } else if (type == 6) {
                        if (!LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.brewingstand")) {
                            anyone = false;
                        }
                    } else if (type == 7) {
                        if (!LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.custom")) {
                            anyone = false;
                        }
                    } else if (type == 4) {
                        if (!LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.trapdoor")) {
                            anyone = false;
                        }
                    } else if (type == 5) {
                        if (!LocketteBlockListener.plugin.hasPermission(block.getWorld(), player, "lockette.admin.create.door")) {
                            anyone = false;
                        }
                    } else {
                        anyone = false;
                    }
                }
                if (!anyone) {
                    event.setLine(1, player.getName().substring(0, length));
                }
                if (!typeWallSign) {
                    block.setType(Material.WALL_SIGN);
                    block.setData(face);
                    sign = (Sign)block.getState();
                    sign.setLine(0, event.getLine(0));
                    sign.setLine(1, event.getLine(1));
                    sign.setLine(2, event.getLine(2));
                    sign.setLine(3, event.getLine(3));
                    sign.update(true);
                } else {
                    block.setData(face);
                }
                if (anyone) {
                    Lockette.log.info("[" + LocketteBlockListener.plugin.getDescription().getName() + "] (Admin) " + player.getName() + " has claimed a container for " + event.getLine(1) + ".");
                    if (!LocketteBlockListener.plugin.playerOnline(event.getLine(1))) {
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-admin-claim-error", event.getLine(1));
                    } else {
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-admin-claim", event.getLine(1));
                    }
                } else {
                    Lockette.log.info("[" + LocketteBlockListener.plugin.getDescription().getName() + "] " + player.getName() + " has claimed a container.");
                    LocketteBlockListener.plugin.localizedMessage(player, null, "msg-owner-claim");
                }
                break block124;
            }
            if (text.equalsIgnoreCase("[More Users]") || text.equalsIgnoreCase(Lockette.altMoreUsers)) {
                checkBlock = new Block[4];
                signBlock = null;
                sign = null;
                face = 0;
                length = player.getName().length();
                if (length > 15) {
                    length = 15;
                }
                if ((Lockette.protectDoors || Lockette.protectTrapDoors) && typeWallSign) {
                    checkBlock[0] = Lockette.getSignAttachedBlock(block);
                    if (checkBlock[0] != null && !this.isInList(checkBlock[0].getTypeId(), this.materialListBad) && (signBlock = Lockette.findBlockOwner(checkBlock[0])) != null && (sign = (Sign)signBlock.getState()).getLine(1).replaceAll("(?i)\u00a7[0-F]", "").equals(player.getName().substring(0, length))) {
                        face = block.getData();
                    }
                }
                if (face == 0) {
                    checkBlock[0] = block.getRelative(BlockFace.NORTH);
                    checkBlock[1] = block.getRelative(BlockFace.EAST);
                    checkBlock[2] = block.getRelative(BlockFace.SOUTH);
                    checkBlock[3] = block.getRelative(BlockFace.WEST);
                    x = 0;
                    while (x < 4) {
                        if (this.isInList(checkBlock[x].getTypeId(), this.materialList) && (Lockette.protectTrapDoors || checkBlock[x].getTypeId() != Material.TRAP_DOOR.getId()) && (Lockette.protectDoors || !this.isInList(checkBlock[x].getTypeId(), this.materialListDoors)) && (signBlock = Lockette.findBlockOwner(checkBlock[x])) != null && (sign = (Sign)signBlock.getState()).getLine(1).replaceAll("(?i)\u00a7[0-F]", "").equals(player.getName().substring(0, length))) {
                            face = LocketteBlockListener.faceList[x];
                            break;
                        }
                        ++x;
                    }
                }
                if (face == 0) {
                    event.setLine(0, "[?]");
                    if (sign != null) {
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-error-adduser-owned", sign.getLine(1));
                    } else {
                        LocketteBlockListener.plugin.localizedMessage(player, null, "msg-error-adduser");
                    }
                    return;
                }
                event.setCancelled(false);
                if (!typeWallSign) {
                    block.setType(Material.WALL_SIGN);
                    block.setData(face);
                    sign = (Sign)block.getState();
                    sign.setLine(0, event.getLine(0));
                    sign.setLine(1, event.getLine(1));
                    sign.setLine(2, event.getLine(2));
                    sign.setLine(3, event.getLine(3));
                    sign.update(true);
                } else {
                    block.setData(face);
                }
                LocketteBlockListener.plugin.localizedMessage(player, null, "msg-owner-adduser");
            }
        }
    }

    private static boolean canBuildDoor(Block block, Block against, Player player) {
        if (!Lockette.isOwner(against, player.getName())) {
            return false;
        }
        if (Lockette.protectTrapDoors && block.getTypeId() == Material.TRAP_DOOR.getId()) {
            return true;
        }
        if (!Lockette.isOwner(against.getRelative(BlockFace.UP, 3), player.getName())) {
            return false;
        }
        Block checkBlock = block.getRelative(BlockFace.NORTH);
        if (checkBlock.getTypeId() == block.getTypeId() && !Lockette.isOwner(checkBlock, player.getName())) {
            return false;
        }
        checkBlock = block.getRelative(BlockFace.EAST);
        if (checkBlock.getTypeId() == block.getTypeId() && !Lockette.isOwner(checkBlock, player.getName())) {
            return false;
        }
        checkBlock = block.getRelative(BlockFace.SOUTH);
        if (checkBlock.getTypeId() == block.getTypeId() && !Lockette.isOwner(checkBlock, player.getName())) {
            return false;
        }
        checkBlock = block.getRelative(BlockFace.WEST);
        return checkBlock.getTypeId() != block.getTypeId() || Lockette.isOwner(checkBlock, player.getName());
    }

    private boolean isInList(int target, int[] list) {
        if (list == null) {
            return false;
        }
        int x = 0;
        while (x < list.length) {
            if (target == list[x]) {
                return true;
            }
            ++x;
        }
        return false;
    }
}

