/*
 * Decompiled with CFR 0.152.
 */
package org.yi.acru.bukkit.Lockette;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.yi.acru.bukkit.Lockette.Lockette;

public class LocketteDoorCloser
implements Runnable {
    private static Lockette plugin;
    private static int doorTask;
    private final PriorityQueue<closeTask> closeTaskList = new PriorityQueue();

    static {
        doorTask = -1;
    }

    public LocketteDoorCloser(Lockette instance) {
        plugin = instance;
    }

    protected boolean start() {
        if (doorTask != -1) {
            return false;
        }
        doorTask = plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)this, 100L, 10L);
        return doorTask == -1;
    }

    protected boolean stop() {
        if (doorTask == -1) {
            return false;
        }
        plugin.getServer().getScheduler().cancelTask(doorTask);
        doorTask = -1;
        this.cleanup();
        return false;
    }

    protected void cleanup() {
        while (!this.closeTaskList.isEmpty()) {
            closeTask door = this.closeTaskList.poll();
            if (door == null) break;
            this.close(door);
        }
    }

    @Override
    public void run() {
        if (this.closeTaskList.isEmpty()) {
            return;
        }
        Date time = new Date();
        while (time.after(this.closeTaskList.peek().time)) {
            closeTask door = this.closeTaskList.poll();
            if (door == null) break;
            this.close(door);
            if (this.closeTaskList.isEmpty()) break;
        }
    }

    private void close(closeTask door) {
        Lockette.toggleHalfDoor(door.world.getBlockAt(door.x, door.y, door.z), door.effect);
    }

    public void add(List<Block> list, boolean auto, int delta) {
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        World world = list.get(0).getWorld();
        Iterator<closeTask> it = this.closeTaskList.iterator();
        block0: while (it.hasNext()) {
            closeTask task = it.next();
            if (!task.world.equals(world)) continue;
            Iterator<Block> itb = list.iterator();
            while (itb.hasNext()) {
                Block block = itb.next();
                if (block.getX() != task.x || block.getY() != task.y || block.getZ() != task.z) continue;
                it.remove();
                itb.remove();
                continue block0;
            }
        }
        if (!auto) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        Date time = new Date();
        time.setTime(time.getTime() + (long)delta * 1000L);
        int x = 0;
        while (x < list.size()) {
            this.closeTaskList.add(new closeTask(time, list.get(x), x == 0));
            ++x;
        }
    }

    protected class closeTask
    implements Comparable<closeTask> {
        Date time;
        World world;
        int x;
        int y;
        int z;
        boolean effect;

        public closeTask(Date taskTime, Block block, boolean taskEffect) {
            this.time = taskTime;
            this.world = block.getWorld();
            this.x = block.getX();
            this.y = block.getY();
            this.z = block.getZ();
            this.effect = taskEffect;
        }

        @Override
        public int compareTo(closeTask arg) {
            return this.time.compareTo(arg.time);
        }
    }
}

